import platform
import tkinter as tk
from tkinter import *
from tkinter import ttk
from tkinter import messagebox
from serial.tools import list_ports
import time
import subprocess,os,inspect

###############################################
# Converted to exe via auto-py-to-exe
#https://pypi.org/project/auto-py-to-exe/
###############################################
# All GUI text can be change on this section
###############################################
windowTitle =  "Uno Qwick Setup"

topLabelDefaultValue = "Write firmware via :"
topLabelWritingValue = "Writing..."
topLabelDoneValue = "Completed"
topLabelDetectingValue = "Detecting..."

startCaptionValue = "Start"

assistedComportBorderValue = "Automatic detection"
assistedComportPopups1_3Title = "Step 1/3"
assistedComportPopups2_3Title = "Step 2/3"
assistedComportPopups3_3Title = "Step 3/3"
assistedComportPopups4_3Title = "Done :)"
assistedComportPopupsNoUnoTitle = "Not detected :("

assistedComportPopups1_3Content = "Make sure your UNO board is disconnected.\nPress ok to continue"
assistedComportPopups2_3Content = "Connect your UNO board.\nPress ok to continue"
assistedComportPopups3_3Content = "UNO board found, press ok to write the firmware ("
assistedComportPopups4_3Content = "The UNO board is now ready for Python !"
assistedComportPopupsNoUnoContent = "Unable to determine the UNO board COM port.\nYou may need to install the COM port driver."

openWindowsDeviceManager = "Open Windows Device Manager"

userDefiniedComportBorderValue = "User defined COM port"
###############################################


class Interface(Frame):
    
	def __init__(self, root, **kwargs):
		Frame.__init__(self, root,**kwargs)
		root.title(windowTitle)
		root.geometry("275x250")
		root.resizable(0,0)
		windowWidth = root.winfo_reqwidth()
		windowHeight = root.winfo_reqheight()
		positionRight = int(root.winfo_screenwidth()/2 - windowWidth/2)
		positionDown = int(root.winfo_screenheight()/2 - windowHeight/2)
		root.geometry("+{}+{}".format(positionRight, positionDown))
		
		self.pack()
		self.nb_clic = 0
		
		self.topLabel = Label(self, text=topLabelDefaultValue,font=("Helvetica", 12))
		self.topLabel.grid(column = 0 , row = 0,pady=5)		
		
		self.assistedComportLabel = ttk.Labelframe(self, text=assistedComportBorderValue,border=10)
		self.btnAsssited = Button(self.assistedComportLabel, text=startCaptionValue, fg="blue",command=self.autoDetectComPort,width=6,font=("Helvetica", 10))
		self.btnAsssited.grid(column = 0 , row = 1,padx=40)
		self.assistedComportLabel.grid(pady=10)
		
		
		self.userDefinedComportLabel = ttk.Labelframe(self, text=userDefiniedComportBorderValue,border=10)
		self.commPortList = ttk.Combobox(self.userDefinedComportLabel,values=foundPort,state="readonly" ,width=10,font=("Helvetica", 10))
		self.commPortList.current(0)
		self.commPortList.grid(column = 0,row = 2)
		self.btnStartUserDefiniedComport = Button(self.userDefinedComportLabel, text=startCaptionValue, fg="blue",command=self.WriteFWUserDefiniedComport,width=6,font=("Helvetica", 10))
		self.btnStartUserDefiniedComport.grid(column = 1 , row = 2)
		self.userDefinedComportLabel.grid(pady=10)

		self.btnAsssited = Button(self, text=openWindowsDeviceManager, fg="purple",command=self.openWDM,font=("Helvetica", 10))
		self.btnAsssited.grid(pady=11)

	def openWDM(self):
		startupinfo = subprocess.STARTUPINFO()
		startupinfo.dwFlags |= subprocess.STARTF_USESHOWWINDOW
		subprocess.call("devmgmt.msc",shell=True,startupinfo=startupinfo)

		
	def autoDetectComPort(self):
		self.topLabel.configure(text=topLabelDetectingValue,fg="green")
		self.btnAsssited.configure(state='disabled')
		self.btnStartUserDefiniedComport.configure(state='disabled')
		self.commPortList.configure(state='disabled')
		Tk.update(root)
		messagebox.showinfo(assistedComportPopups1_3Title,assistedComportPopups1_3Content)
		portListWhtUNO = list()
		for n, (port, desc, hwid) in enumerate(sorted(list_ports.comports()), 1):
			portListWhtUNO.append(port)
		messagebox.showinfo(assistedComportPopups2_3Title,assistedComportPopups2_3Content)
		portListWhUNO = list()
		for n, (port, desc, hwid) in enumerate(sorted(list_ports.comports()), 1):
			portListWhUNO.append(port)
			
		if len(portListWhUNO) == (len(portListWhtUNO)+1) :
			for testPort in portListWhUNO:
				if testPort not in portListWhtUNO:
					print("UNO board found on :"+testPort)
					messagebox.showinfo(assistedComportPopups3_3Title, assistedComportPopups3_3Content+testPort+")")
					self.topLabel.configure(text=topLabelWritingValue+"("+testPort+")",fg="red")
					Tk.update(root)
					startupinfo = subprocess.STARTUPINFO()
					startupinfo.dwFlags |= subprocess.STARTF_USESHOWWINDOW
					subprocess.call("\""+os.path.dirname(os.path.abspath(inspect.stack()[0][1]))+"\\ressources\\flashScriptComarg1.bat\" \""+os.path.dirname(os.path.abspath(inspect.stack()[0][1]))+"\\ressources\" \""+testPort+"\"",shell=True,startupinfo=startupinfo)
					messagebox.showinfo(assistedComportPopups4_3Title, assistedComportPopups4_3Content)
					self.topLabel.configure(text=topLabelDefaultValue,fg="black")
					self.btnAsssited.configure(state="normal")
					self.btnStartUserDefiniedComport.configure(state="normal")
					self.commPortList.configure(state='normal')
					break
		else :
			messagebox.showwarning(assistedComportPopupsNoUnoTitle,assistedComportPopupsNoUnoContent)
			self.topLabel.configure(text=topLabelDefaultValue,fg="black")
			self.btnAsssited.configure(state="normal")
			self.btnStartUserDefiniedComport.configure(state="normal")
			self.commPortList.configure(state='normal')
		
    
	def WriteFWUserDefiniedComport(self):
		if self.commPortList.get() is not "":
			startupinfo = subprocess.STARTUPINFO()
			startupinfo.dwFlags |= subprocess.STARTF_USESHOWWINDOW
			self.topLabel.configure(text=topLabelWritingValue+"("+self.commPortList.get()+")",fg="red")
			self.btnAsssited.configure(state='disabled')
			self.btnStartUserDefiniedComport.configure(state='disabled')
			self.commPortList.configure(state='disabled')
			Tk.update(root)
			subprocess.call("\""+os.path.dirname(os.path.abspath(inspect.stack()[0][1]))+"\\ressources\\flashScriptComarg1.bat\" \""+os.path.dirname(os.path.abspath(inspect.stack()[0][1]))+"\\ressources\" \""+self.commPortList.get()+"\"",shell=True,startupinfo=startupinfo)
			self.topLabel.configure(text=topLabelDoneValue,fg="green")
			Tk.update(root)
			time.sleep(1)
			Tk.update(root)
			self.topLabel.configure(text=topLabelDefaultValue,fg="black")
			Tk.update(root)
			self.btnAsssited.configure(state="normal")
			self.btnStartUserDefiniedComport.configure(state="normal")
			self.commPortList.configure(state='normal')
		
foundPort = list()
for n, (port, desc, hwid) in enumerate(sorted(list_ports.comports()), 1):
	foundPort.append(port)
while len(foundPort) < 2 :
	foundPort.insert(len(foundPort),"")			

root = Tk()
interface = Interface(root)
interface.mainloop()
