/*
 * Ultrasonic.cpp
 * A library for ultrasonic ranger
 *
 * Copyright (c) 2012 seeed technology inc.
 * Website    : www.seeed.cc
 * Author     : LG, FrankieChu
 * Create Time: Jan 17,2013
 * Change Log :
 *
 * The MIT License (MIT)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
#include <stdio.h>
#include <string.h>
#include <inttypes.h>
#include "Arduino.h"
#include "UltrasonicLight.h"

/*
void UltrasonicLight::ISR_CALLBACK(){
  if (_currentState == 1){
    duration = micros();
    detachInterrupt(digitalPinToInterrupt(_pin));
    attachInterrupt(digitalPinToInterrupt(_pin), ISR_CALLBACK, RISING);
    _currentState = 2;
  }else if(_currentState == 2){
    duration = duration - micros();
    _currentState = 3;
    detachInterrupt(digitalPinToInterrupt(_pin));
  }
}*/

UltrasonicLight::UltrasonicLight(int pin){
  _pin = pin;
  _currentState = 0;
  started = 0;
}


uint8_t UltrasonicLight::CheckForResult(void){

  if ( (millis() - started) > 500){
    _currentState = 0;
    started = millis();
  }
  
  
  switch(_currentState){
    case 0:{
      pinMode(_pin, OUTPUT);
      digitalWrite(_pin, LOW);
      delayMicroseconds(2);
      digitalWrite(_pin, HIGH);
      delayMicroseconds(5);
      digitalWrite(_pin,LOW);
      pinMode(_pin,INPUT);
      if (digitalRead(_pin))
        _currentState=1; // Wait for any previous pulse to end -> next must fall
      else
        _currentState=2; // Next step is wait for the pulse to start counter -> next must rise
      return 0x5A;
    }break;
    case 4:{
      return 0xFF;
    }break;
    default:break;
  }
  return 0x00;
}

unsigned int UltrasonicLight::GetResult(void){
  _currentState = 0;
  return duration;
}
