// 
//     Sciencéthic
//
//     Thermomètre numérique par étalonnage de résistance CTN
//

float N;                    // Définit un nombre flottant N
float T;                    // Définit un nombre flottant T
float R1 = 10000.0000;      // Définit la valeur de R1 la résistance de 10 kOhms

#define BrocheConnexion A0  // Définit la broche sur laquelle sera connectée la sonde de température CTN
                            // Ici, elle sera reliée à l'entrée A0

void setup() {              // Initialisation du programme
  Serial.begin(9600);       // Initialise la vitesse de communication entre la carte Plug'Uino et le PC
                            // à 9600 bps
}

void loop() {               // Boucle principale
 N = analogRead(BrocheConnexion);  // Met dans N la mesure faite sur l'entrée BrocheConnexion
float Ur1 = 5.000000*N/1023.000000; // Comvertit le nombre N en tension Ur mesurée sur BrocheConnexion
float R = R1*(5-Ur1)/Ur1;       // Calcule la résistance de la CTN à partir de la valeur de Ur1
 T =-26.04*log(R)+265.26;
                            //  La ligne 23 calcule la valeur de la température qui correspond à R
                            // à partir de la courbe d'étalonnage
                            // Remarque : dans Arduino, la fonction logarithme néperien se note log
                            // et le logarithme décimal log10
 Serial.print("Température : "); // Affiche "Température :"
 Serial.print(T);           // Affiche la valeur de la température calculée
 Serial.println(" °C");     // Affiche l'unité et passe à la ligne
 delay(1000);               // Attend une seconde avant de boucler
}
