""" Sciencéthic étalonnage d'une sonde de température CTN branché sur la broche
 analogique A0 avec une LED branchée sur la broche digitale D2"""



from pyfirmata2Ext import Arduino, util 
import matplotlib.pyplot as plt
import time                                                             #importation des bibliothèques

#------------------------------- paramétrage de la communication---------------------------------------------
port = Arduino(Arduino.AUTODETECT)                                      # la variable port contient le port de communication COM détecté automatiquement
util.Iterator(port).start()                                             # itérateur permettant de ne pas saturer la liaison série
A0 = port.get_pin('a:0:o')                                              # A0 désigne la broche analogique 0 (a:0) utilisée en sortie (:o) 
time.sleep(0.5)                                                         # délai d'attente pour la mise en place de la communication
port.digital[2].write(1)                                                # écriture sur le port digital 2 (Ok pour mesure si LED allumée)

#------------------------------- mesures --------------------------------------------------------------------
mesures_capteur=[]                                                      # liste des mesures données par le capteur
temperatures=[]                                                         # liste des températures
poursuite=True                                                          # initialisation de la variable poursuite des mesures        
while poursuite:                                                        # tant qu'une mesure est à effectuer
    temperatures.append(float(input(' valeur de la température : ')))   # ajout de la température dans la liste
    m=A0.read()                                                         # lecture de la valeur sur la broche A1
    mesures_capteur.append(m)                                           # ajout de la valeur dans la liste
    print('mesure : ',m)                                                # affichage de la valeur mesurée
    poursuite=input('Déclencher une nouvelle mesure o/n ? ')
    if poursuite=='n'or poursuite=='N':
        poursuite=False
print('liste des mesures : ',mesures_capteur)                           # affichage de la liste des mesures
port.digital[2].write(0)                                                # écriture sur le port digital 2 (fin de mesure si LED éteinte)
port.exit()                                                             # fermeture de la communication sur le port



#------------------------------- tracé ---------------------------------------------------------------------
trace=input('voulez-vous effectuer un tracé o/n : ')
if trace=='o':
    plt.plot(mesures_capteur,temperatures)
    plt.show()




