""" Sciencéthic mesure d'une température avec une sonde de température CTN branché sur la broche
 analogique A0 avec une LED branchée sur la broche digitale D2"""

#-------------------------------Attention --------------------------------------------------
#
# A partir de l'IDE Arduino, téléverser dans la carte Arduino l'exemple "StandardFirmata"
# accessible via :Menu Fichier / Exemples / Firmata / StandardFirmata.
#
#-------------------------------------------------------------------------------------------


from pyfirmata2Ext import Arduino, util 
import matplotlib.pyplot as plt
import time                     #importation des bibliothèques

#------------------------------- paramétrage de la communication---------------------------------------------
com=input('Saisir le port de communication COM1, COM2, COM3 .... :')
port = Arduino(com)            # la variable port contient le port de communication
util.Iterator(port).start()    # itérateur permettant de ne pas saturer la liaison série
A0 = port.get_pin('a:0:o')     # A1 désigne la broche analogique 1 (a:1) utilisée en sortie (:o) 
time.sleep(0.5)                # délai d'attente pour la mise en place de la communication
port.digital[2].write(1)       # écriture sur le port digital 2 (Ok pour mesure si LED allumée)

#------------------------------- mesures --------------------------------------------------------------------

poursuite=True                  # initialisation de la variable poursuite des mesures        
while poursuite:                # tant qu'une mesure est à effectuer
    m=A0.read()                 # lecture de la valeur sur la broche A0
    temperature=330*m*m*m-398*m*m+253*m-44   # calcul de la temperature à partir du modèle
    print('tepérature =  : ',temperature)        # affichage de la valeur mesurée
    poursuite=input('Déclencher une nouvelle mesure o/n ? ')
    if poursuite=='n'or poursuite=='N':
        poursuite=False

port.digital[2].write(0)       # écriture sur le port digital 2 (fin de mesure si LED éteinte)
port.exit()                    # fermeture de la communication sur le port

