//
//      Sciencéthic
//      Synthèse RVB
//      Exemple simple
//
//      Cette utilisation nécessite l'installation de la bibliothèque
//      Adafruit NeoPixel
//      disponible dans "gérer les bibliothèques"
//

# include<Adafruit_NeoPixel.h>    // Inclut la bibliothèque Adafruit_NeoPixel
                                  // Qui permet de gérer l'afficheur 5x5 RVB
                                  // Plug'Uino

Adafruit_NeoPixel matriceLED = Adafruit_NeoPixel(25,2, NEO_GRB + NEO_KHZ800);
                                  // Initialise la matrice : 25 est le nombre de pixels
                                  // 2 est la sortie utilisée (ici, il faut donc brancher
                                  // la matrice sur D2)

void setup()              // Initialisation du programme
{
  matriceLED.begin();     // Initialisation de la matrice
 }

void loop()               // Boucle principale
{
// La syntaxe est la suivante :
// matriceLED.setPixelColor(numéro de la LED, matriceLED.Color(valeur Rouge, valeur Vert, Valeur Bleu)
// Les valeurs des couleurs vont de 0 (couleur éteinte) à 100 (intensité la plus forte).
// La LED 0 est la première LED en haut à gauche, puis la numérotation se fait en ligne : la LED 4 est 
// la dernière LED de la première ligne, la LED 5 la première LED de la deuxième ligne etc...

// On va afficher ici sur les colonnes 0, 1, 2 les trois couleurs primaires R V B 
// et sur la dernière colonne la somme des trois premières colonnes

// Affichage de Rouge + Vert = Jaune en ligne 0
matriceLED.setPixelColor(0, matriceLED.Color(100,0,0));
matriceLED.setPixelColor(1, matriceLED.Color(0,100,0));
matriceLED.setPixelColor(4, matriceLED.Color(100,100,0));

// Affichage de Rouge + Bleu = Magenta en ligne 1
matriceLED.setPixelColor(5, matriceLED.Color(100,0,0));
matriceLED.setPixelColor(7, matriceLED.Color(0,0,100));
matriceLED.setPixelColor(9, matriceLED.Color(100,0,100));

// Affichage de Vert + Bleu = Cyan en ligne 2
matriceLED.setPixelColor(11, matriceLED.Color(0,100,0));
matriceLED.setPixelColor(12, matriceLED.Color(0,0,100));
matriceLED.setPixelColor(14, matriceLED.Color(0,100,100));

// Affichage de Rouge + Bleu + Vert = Blanc en ligne 3
matriceLED.setPixelColor(15, matriceLED.Color(100,0,0));
matriceLED.setPixelColor(16, matriceLED.Color(0,100,0));
matriceLED.setPixelColor(17, matriceLED.Color(0,0,100));
matriceLED.setPixelColor(19, matriceLED.Color(100,100,100));

matriceLED.show();        // Affiche la matrice
}
