//
//      Sciencéthic
//      Synthèse RVB
//      Réalisation d'un dessin en couleurs
//
//      Cette utilisation nécessite l'installation de la bibliothèque
//      Adafruit NeoPixel
//      disponible dans "gérer les bibliothèques"
//

# include<Adafruit_NeoPixel.h>    // Inclut la bibliothèque Adafruit_NeoPixel
                                  // Qui permet de gérer l'afficheur 5x5 RVB
                                  // Plug'Uino

Adafruit_NeoPixel matriceLED = Adafruit_NeoPixel(25,2, NEO_GRB + NEO_KHZ800);
                                  // Initialise la matrice : 25 est le nombre de pixels
                                  // 2 est la sortie utilisée (ici, il faut donc brancher
                                  // la matrice sur D2)

// Définition du dessin à afficher
int matrice[5][5] = {
 {0,1,1,1,0},         // Le code est le suivant :
 {1,3,1,3,1},         // 0 : pixel éteint
 {1,0,1,0,1},         // 1 : pixel rouge
 {0,1,1,1,0},         // 2 : pixel vert
 {2,2,0,2,2,}         // 3 : pixel bleu
 };
void setup()              // Initialisation du programme
{
  matriceLED.begin();     // Initialisation de la matrice
 }

void loop()               // Boucle principale
{
// La syntaxe est la suivante :
// matriceLED.setPixelColor(numéro de la LED, matriceLED.Color(valeur Rouge, valeur Vert, Valeur Bleu)
// Les valeurs des couleurs vont de 0 (couleur éteinte) à 100 (intensité la plus forte).
// La LED 0 est la première LED en haut à gauche, puis la numérotation se fait en ligne : la LED 4 est 
// la dernière LED de la première ligne, la LED 5 la première LED de la deuxième ligne etc...

int Rouge;
int Vert;
int Bleu;

  for(int y = 0; y < 5; y++)      // Parcourt chaque colonne du tableau
    for(int x = 0; x < 5; x++) {  // Parcourt chaque ligne du tableau
      {
      switch(matrice[x][y])    // selon la valeur lue dans le tableau dessin(x,y)
       {
        case 0: Rouge=0; Vert=0; Bleu=0; break;       // si la valeur vaut 0, ne pas l'allumer
        case 1: Rouge=100; Vert=0; Bleu=0; break;   // si la valeur vaut 1, l'allumer en rouge
        case 2: Rouge=0; Vert=100; Bleu=0; break;   // si la valeur vaut 2, l'allumer en vert
        case 3: Rouge=0; Vert=0; Bleu=100; break;   // si la valeur vaut 2, l'allumer en bleu
        
       }
  matriceLED.setPixelColor(x*5+y, matriceLED.Color(Rouge,Vert,Bleu)); // Allume le pixel en correspondance
      }
   }
matriceLED.show();        // Affiche la matrice
}
