//
//      Sciencéthic
//
//      Télémètre à Ultrasons
//

#define BrocheConnexion 7 // Définit la broche de connexion du module émetteur-récepteur ultrasons
                          // Ici ce dernier doit être connecté sur la broche D7
                          // Vous pouvez changer ce nombre par exemple 2 pour connecté le module
                          // sur la broche D2
float temperature = 19.5 ;  // on entre ici la valeur de la température en °C mesurée pour calculer 
                          // la célérité théorique des ultrasons, ici la temperature est de 19,5 °C

void setup()              // Initialisation du programme
{
    Serial.begin(9600);   // Initialise la vitesse de communication entre la carte Plug'Uino et le PC
                          // à 9600 bps
    }
void loop()               // Boucle principale
{
  float duree = 0;        // initialise la variable duree à 0
  for(int i = 1; i<=5; i++) // démarre une boucle de 5 mesures
  {
    pinMode(BrocheConnexion, OUTPUT);     // Les lignes 24 à 27
    digitalWrite(BrocheConnexion, HIGH);  // génèrent une salve d'ultrasons
    delayMicroseconds(5);                 //
    digitalWrite(BrocheConnexion,LOW);    //
    pinMode(BrocheConnexion,INPUT);       //
    duree = duree + pulseIn(BrocheConnexion,HIGH); // mesure la durée d'aller-retour de la salve et 
                                                   // l'ajoute aux mesures précédentes
    delay(200);                            // Attend 200 ms avant de renvoyer une salve (évite les échos parasites)
  }                                              
  float dureemoyenne = duree*1e-6/5 ;         // calcule la durée moyenne d'aller-retour, convertie en s
  float vitesse_son = 20.05*sqrt(temperature+273.15); // calcule la vitesse du son en fonction de la température
  float distance = vitesse_son*dureemoyenne/2 ; // Calcule la distance qui correspond au produit de la
                                              // vitesse par la moitié de la durée moyenne d'aller-retour
  Serial.print("La distance moyenne est de "); // Affiche la phrase entre guillements
  Serial.print(distance);                      // Affiche la distance
  Serial.println(" m");                     // Affiche l'unité, et passe à la ligne
  delay(250);                                 // Attend 250 ms avant de recommencer
}
