""" Sciencéthic mesures pour loi de l'hydrostatique 
lecture sur une broche analogique d'un microcontrôleur type Arduino 
capteur branché sur la broche analogique A1, LED branchée sur la broche digitale D2"""
# ------------------------------importation des bibliothèques-----------------------------------------
from pyfirmata import Arduino, util
import time                         

#------------------------------- paramétrage de la communication---------------------------------------
com=input('Saisir le port de communication COM1, COM2, COM3 .... :')
port = Arduino(com)         # la variable port contient le port de communication
util.Iterator(port).start()    # itérateur permettant de ne pas saturer la liaison série
A1 = port.get_pin('a:1:o')     # A1 désigne la broche analogique 1 (a:1) utilisée en sortie (:o) 
time.sleep(0.5)                # délai d'attente pour la mise en place de la communication
port.digital[2].write(1)       # écriture sur le port digital 2 (Ok pour mesure si LED allumée)

#------------------------------- mesures --------------------------------------------------------------
mesure=[]                   	# liste des profondeurs
profondeur=[]                   # liste des profondeurs
poursuite=True                  # initialisation de la variable poursuite des mesures
while poursuite:                # tant qu'une mesure est à effectuer
	prof=float(input('profondeur en mètre :'))   # saisie de la profondeur
	profondeur.append(prof)             # enregistrement de la profondeur dans la liste
	a=input('taper ENTER pour effectuer la mesure') # déclenchement de la mesure
	m=A1.read()                         # lecture de la mesure sur la broche
	mesure.append(m)                    # ajout de la mesure dans la liste
	print('mesure : ',m)                # affichage de la mesure
	poursuite=input('nouvelle mesure o/n : ')
	if poursuite!='o' and poursuite!='O':
		poursuite=False

port.digital[2].write(0)  			 # écriture sur le port digital 2 (fin de mesure LED éteinte)    
port.exit()                          # fermeture de la communication sur le port
print()
print('profondeurs : ',profondeur)   # affichage de la série des profondeurs
print('mesures : ',mesure)           # affichage de la série de mesures


#-------------------------------- partie de script optionnelle : tracés (peut être effacée)---------------
print('----------------------------------')
traces=input('Voulez-vous effectuer un tracé de ces mesures o/n ?')
if traces=='o' or traces=='O':
	import numpy as np  			# importation de la bibliothèque pour le calcul de régression linéaire
	import matplotlib.pyplot as plt # bibliothèque de tracés
	
	pression=[]         			# initialisation de la liste des pressions
	for i in range(len(mesure)):    
		pression.append(mesure[i]*7310-731) # calcul pression en fonction du modèle du capteur
	regression = np.polyfit(profondeur, pression, 1)    # régression linéaire
	f_reg=np.poly1d(regression)                         # initialisation de la fonction modèle linéaire
	
	plt.plot(profondeur,pression,'+',label='mesures')   # tracé des valeurs expérimentales
	x=np.linspace(0,1.2*max(profondeur),50)             # création des abcisses pour le tracé du modèle
	plt.plot(x,f_reg(x),'-',color='r',label='régression linéaire')      # tracé du modèle
	plt.title('delta P=f(profondeur)')  # titre de la figure
	plt.xlim(0, 1.2*max(profondeur))    # paramétrage axe des abscisses entre 0 et 1,2*profondeur max
	plt.ylim(0, 1.2*max(pression))      # paramétrage axe des ordonnées entre 0 et 1,2*pression max
	plt.xlabel('profondeur (m)')        # légendes des axes
	plt.ylabel('delta P(Pa)')
	plt.legend(loc='lower right',fontsize=12) # paramétrages de la légende
	plt.show()                                # tracé de la figure



