""" Sciencéthic mesures pour loi de Mariotte 
lecture sur une broche analogique d'un microcontrôleur type Arduino 
capteur branché sur la broche analogique A1, LED branchée sur la broche digitale D2"""
# ------------------------------importation des bibliothèques-----------------------------------------
from pyfirmata import Arduino, util
import time                         

#------------------------------- paramétrage de la communication---------------------------------------
com=input('Saisir le port de communication COM1, COM2, COM3 .... :')
port = Arduino(com)            # la variable port contient le port de communication
util.Iterator(port).start()    # itérateur permettant de ne pas saturer la liaison série
A1 = port.get_pin('a:1:o')     # A1 désigne la broche analogique 1 (a:1) utilisée en sortie (:o) 
time.sleep(0.5)                # délai d'attente pour la mise en place de la communication
port.digital[2].write(1)       # écriture sur le port digital 2 (Ok pour mesure si LED allumée)

#------------------------------- mesures --------------------------------------------------------------
mesure=[]                            # liste des mesures
volume=[]                            # liste des volumes
poursuite=True
while poursuite:
    v=float(input('volume en mL :'))
    volume.append(v)
    a=input('taper ENTER pour effectuer la mesure')
    m=A1.read()
    mesure.append(m)
    print('mesure : ',m)
    poursuite=input('nouvelle mesure o/n : ')
    if poursuite!='o' and poursuite!='O':
        poursuite=False

port.digital[2].write(0)  			 # écriture sur le port digital 2 (fin de mesure LED éteinte)    
port.exit()                          # fermeture de la communication sur le port

print('Volumes :  :',volume)
print('Mesures :  :',mesure)


#-------------------------------- partie de script optionnelle : tracés (peut être effacée)---------------
print('----------------------------------')
traces=input('Voulez-vous effectuer un tracé de ces mesures o/n ?')
if traces=='o' or traces=='O':
    import numpy as np  			# importation de la bibliothèque pour le calcul de régression linéaire
    import matplotlib.pyplot as plt # bibliothèque de tracés
    inv_v=[]
    pression=[]
    for i in range(len(mesure)):
        inv_v.append(1/(volume[i]+3.1))
        pression.append(mesure[i]*3010)
    regression = np.polyfit(inv_v, pression, 1)
    f_reg=np.poly1d(regression)
    x=np.linspace(0,1.2*max(inv_v),50)
    plt.plot(x,f_reg(x),'-',color='r',label='régression linéaire')
    plt.title('P=f(1/V)')
    plt.plot(inv_v,pression,'+',label='mesures')
    plt.xlim(0, 1.2*max(inv_v))
    plt.ylim(0, 1.2*max(pression))
    plt.xlabel('1/V (cm-3)')
    plt.ylabel('pression(hPa)')
    plt.legend(loc='lower right',fontsize=12)
    plt.show()