  /********** Charge et décharge d'un condensateur ***************
 * 
 * On mesure la tension aux bornes d'un condensateur pendant qu'il
 * se charge, puis pendant qu'il se décharge.  La mesure de la tension
 * est prise toutes les 10 ms.
 * 
 * Yves Pelletier
 *
 * http://electroniqueamateur.blogspot.com/2015/03/observer-la-charge-et-la-decharge-dun.html
 *
 ***************************************************************/

int etat = 0;  // 0 au début, 1 pendant la charge
               // 2 pendant la décharge, 3 quand c'est fini
long previousMillis = 0; 
long interval = 10;  // nombre de millisecondes entre chaque mesure
int Time = 0;

void setup() {   

  pinMode(8, OUTPUT);  // alimentation du condensateur
  Serial.begin(9600);  

  // dans un premier temps, on s'assure que le condensateur est 
  // completement déchargé

  Serial.println("Charge Décharge t=");
  digitalWrite(8,LOW);
  delay(2000);

 

}



void loop() {

  int currentMillis = millis();
  float tension;
  char t[50];
  float tps;
  
  if (etat == 0) { 
  
  Time=currentMillis; // on enregistre le temps de départ
  // nouvel etat:  charge du condensateur
  etat = 1;
 
  digitalWrite(8,HIGH);  // on met en marche l'alimentation
  }

  if(currentMillis - previousMillis >= interval) {
    
    // il est temps de prendre une nouvelle mesure

    previousMillis = currentMillis;

    if (etat == 1) {  // charge du condensateur
      tension = analogRead(A0)*5.0/1024.0;
      tps = 0;
      if (tension < 4.65){  // pas completement chargé
        if ( tension > 3.0 && tension < 3.1){
          sprintf (t, "Charge Décharge t=%ums",previousMillis- Time);
          tps = tension;
          
        }
        Serial.print(tension);
        Serial.print(",");
        Serial.print(0);
        Serial.print(",");
        Serial.print(tps);   
        Serial.println();     
      }
      else{  // completement chargé
        // on change d'état:  décharge du condensateur
        etat = 2;
        Serial.println(t);
        digitalWrite(8,LOW);  // désactivation de l'alimentation
      }
    }

    if (etat == 2) {  // décharge
      tension = analogRead(A0)*5.0/1024.0;
      if (tension > 0.01){ // pas completement déchargé
        Serial.print("Charge,");
        Serial.print(tension);
        Serial.println();
      }
      else {  // completement déchargé
        etat = 3;  // on change d'état:  tout est terminé
      }

    }
  }


}
