# /********** Charge et décharge d'un condensateur ***************
#  * 
#  * On mesure la tension aux bornes d'un condensateur pendant qu'il
#  * se charge, puis pendant qu'il se décharge.  La mesure de la tension
#  * est prise toutes les 10 ms.
#  * 
#  * 
#  ***************************************************************/

from pyfirmata2Ext import Arduino, util 
import matplotlib.pyplot as plt # Importation de la bibliothéque néccéssaire pour tracer des graphiques
import time

#importation des bibliothèques
     
#------------------------------- paramétrage de la communication---------------------------------------------
port = Arduino(Arduino.AUTODETECT)              # la variable port contient le port de communication
util.Iterator(port).start()    # itérateur permettant de ne pas saturer la liaison série
a0 = port.get_pin('a:0:i')     # A0 désigne la broche analogique 0 (a:0) utilisée en entrée (:i) 
port.digital[8].write(1)       # écriture sur le port digital 8 
time.sleep(0.5)                # délai d'attente pour la mise en place de la communication








etat = 0# 0 au début, 1 pendant la charge, 2 pendant la décharge, 3 quand c'est fini

previousMillis = 0 # variable qui retient les anciennes valeurs en ms

interval = 10  # Nombre de millisecondes entre chaque mesure


# temps associer à la mesure
tempsdecharge=[]
tempsdedecharge=[]
TempsCaract=[]

# liste des tensions
tensionsdecharge=[]
tensionsdedecharge=[]
TensionCaract=[]

# Dans un premier temps, on s'assure que le condensateur est complètement déchargé

  
port.digital[8].write(0) # Mise à l'état bas (0 V) de la sortie D8
  
time.sleep(2)      #Délai d'attente de 2000 ms



 
#Définition de "tempsCaract"comme la valeur du temps caractéristique
tempsCaract=[]


startms = 0



while etat < 3 :
    
    
    if etat == 0 :
        etat = 1 # nouvel état:charge du condensateur
        startms = time.time()*1000 # On enregistre le temps de départ en ms
        port.digital[8].write(0) # Mise à l'état bas (0 V) de la sortie D8

    currentMillis = time.time()*1000 - startms
    tension = 0.0#Définition de "tension" comme un nombre à virgule flottante

     #Définition de "TensionCaract"comme la valeur de la tension à t = Temps caractéristique
    
  
    if currentMillis - previousMillis >= interval :
        
        # Prendre une mesure à chaque intervalle de temps définit par la variable "interval" (interval = 10 ms)
       
        previousMillis = currentMillis

        if etat == 1 :   # Charge du condensateur avec une tension de 5 V
            
            port.digital[8].write(1)  # On alimente le circuit avec une tension de 5 V (délivrée par le microcontrôleur sur D8 )
            
            tension = 6.2*a0.read()  #Conversion de la valeur numérisée de A0 en une valeur de tension en Volts
            #(on fait x6.2 au lieu de 5 pour compenser le retard de communication entre la carte et l'ordinateur) 
            
           
            
            tensionsdecharge.append(tension) # ajout de la tension dans le tableau tensionsdecharge
            tempsdecharge.append(currentMillis) # ajout du temps dans le tableau tempsdecharge
            
            if tension < 4.7 : # Si le condensateur n'est pas complètement chargé on rentre dans la condition ci-dessous
                
                if tension > 3.0 and tension < 3.2 : #Si la tension aux bornes du condensateur atteint 63% de la valeur max (5 V) alors...
                    
                     
                    #Enregistre le temps caractéristique dans le tableau TempsCaract
                    TensionCaract.append(0) # Courbe
                    TensionCaract.append(tension)# Courbe
                    TempsCaract.append(currentMillis-1/1000.0)# Courbe
                    TempsCaract.append(currentMillis)# Courbe
                    tempsCaract.append(currentMillis)# Légende de la Courbe
                    
        
                    # Enregistre le moment où la tension atteint une valeur entre  3 et 3,1 V, 
                    # c'est-à-dire le temps caractéristique à 63% de la valeur finale de la tension aux bornes du condensateur chargé. 
                    
                
                    
              
            else : # Sinon, si le condensateur est complètement chargé, on change d'état: décharge du condensateur
            
                etat = 2
                
                port.digital[8].write(0)  # On coupe l'alimentation du circuit, en mettant la sortie D8 à l'état bas (0 V)

        if etat == 2 : # décharge
            
            tension = 6.2*a0.read() #Conversion de la valeur numérisée de A0 en une valeur de tension en Volts.
            #(on fait x6.2 au lieu de 5 pour compenser le retard de communication entre la carte et l'ordinateur) 
            tensionsdedecharge.append(tension)# ajout de la tension dans le tableau tensionsdedecharge
            tempsdedecharge.append(currentMillis)# ajout du temps dans le tableau tempsdedecharge
            if tension < 0.01 : # complètement déchargé
                  
            
                etat = 3  # on change d'état:  tout est terminé
            
    
    

port.exit()
#############################################################################################
#                  Tracé du graphique
#############################################################################################

 # pour réaliser des tracés
import matplotlib.pyplot as plt


fig, ax = plt.subplots()
ax.plot(tempsdecharge,tensionsdecharge,'r', label='Charge du Condensateur') # Courbe de Charge en rouge
ax.plot(TempsCaract,TensionCaract,'g', label='Temps Caractéristique = %s ms' %(round(min(tempsCaract),1)))# Courbe du Temps Caratéristique en vert
ax.plot(tempsdedecharge,tensionsdedecharge,'b', label='Décharge du Condensateur') # Courbe de Décharge en bleu

legend = ax.legend(loc='upper center', shadow=False, fontsize='x-large')
plt.ylabel('Tension(V)') #Légende
plt.xlabel('Temps(s)') #Légende
plt.show()
    
print("\nL exécution du programme s est terminée sans erreur ! \n\n")
