
const debug = true;
var MODE_ACQUISITION = "reel";
// BLE Section
const targetDeviceAdvName = "301037";
const FFF0ServiceUUID 				= "0000fff0-0000-1000-8000-00805f9b34fb";
const uartRxcharacteristicUUID 		= "0000fff1-0000-1000-8000-00805f9b34fb";
const uartTxcharacteristicUUID 		= "0000fff2-0000-1000-8000-00805f9b34fb";

// navigator.bluetooth.getAvailability().then(available => {
//     if (!available){
//         alert("Oops, impossible de continuer.\nVotre appareil semble être dépourvu de connectivité Bluetooth BLE. Assurez-vous d'avoir installé un adaptateur Bluetooth compatible BLE (>=4.0).");
//         // document.write('</html><!--');
//         window.location = "/"
//     }
// });

const container = document.getElementById('containerapp');
var decoder = new TextDecoder();
var ID_DEVICE = new Array();
var bluetoothDevice = new Array(2);
for(let i = 0; i <= 1; i++){
    ID_DEVICE[i] = null;
    bluetoothDevice[i] = new Array(4);
    bluetoothDevice[i][0] = i;
    bluetoothDevice[i][1] = "";
    bluetoothDevice[i][2] = "";
    bluetoothDevice[i][3] = "";


}




{	
    let mapsettingsSampleRate = document.getElementById('mapsettingsSampleRate');
    
    for (let n = 0 ; n <= 100; n+=10 ){		
        // console.log(n)
        let el = document.createElement('option');
        el.innerHTML = n;
        mapsettingsSampleRate.appendChild(el);
    }
}
{	
    let mapsettingsSamplePoint = document.getElementById('mapsettingsSamplePoint');
    
    for (let n = 10 ; n <= 100; n+=10 ){		
        // console.log(n)
        let el = document.createElement('option');
        el.innerHTML = n;
        mapsettingsSamplePoint.appendChild(el);
    }
}

function openparamgraph(){
    if(!isstart){
        document.getElementById("paramGraph").style.display = "block";
    }else{
        window.alert("Action impossible lors d'une acquisition !")
    }
}


var samplingRate = 50;
var sampleRateVal = (1 / samplingRate) *1000;
var samplingPointOnGraph = 30;

function UIRangleLabelHandler(id,value){document.getElementById(id).innerHTML = value;}
function handlerSamplingRate(value){
    // if (value > 100) document.getElementById('use8bitSamplingChkBox').checked = true;		
    samplingRate = parseInt(value);
    sampleRateVal = (1/ samplingRate) *1000;
    UIRangleLabelHandler('samplingRateLabel',samplingRate);
}
// function UIRangleLabelHandler(id,value){document.getElementById(id).innerHTML = value;}
function handlerSamplingPoint(value){
    // if (value > 100) document.getElementById('use8bitSamplingChkBox').checked = true;		
    samplingPointOnGraph = parseInt(value);

    // sampleRateVal = (1/ samplingRate) *1000;
    UIRangleLabelHandler('samplingPointLabel',samplingPointOnGraph);
}
// function validateparam(){
//     document.getElementById("paramGraph").style.display = "none";
// }

document.getElementById("submitbtnParam").addEventListener("click", function(event) {
    // Masquer le paramètre graphique
    document.getElementById("paramGraph").style.display = "none";

    // Gestion du mode d'acquisition
    if(document.getElementById("A_clavier").checked) {
        MODE_ACQUISITION = "clavier";
        document.getElementById("ECLcontainer").style.display = "flex";
        config.options.scales.xAxes.title.text = document.getElementById("unitECL").value;
    } else {
        MODE_ACQUISITION = "reel";
        document.getElementById("ECLcontainer").style.display = "none";
        config.options.scales.xAxes.title.text = "Temps (en s)";
    }

    // Gestion de l'affichage des points
    if(document.getElementById("AffichPoint").checked) {
        config.options.elements.point.radius = 5;
    } else {
        config.options.elements.point.radius = 0;
    }

    // Gestion de l'affichage des lignes
    deviceOnGraph.forEach(element => {
        if(element != null) {
            let datasetIndex = deviceOnGraph.indexOf(element);
            if(config.data.datasets[datasetIndex]) {  // Vérifie si le dataset existe
                if(document.getElementById("relic").checked) {
                    config.data.datasets[datasetIndex].showLine = true;
                } else {
                    config.data.datasets[datasetIndex].showLine = false;
                }
            }
        }
    });

    reInitChart();
});

document.getElementById("AffichPoint").addEventListener("change", function(){
    if(document.getElementById("relic").checked == false){
        document.getElementById("AffichPoint").checked = true;
    }
});
document.getElementById("relic").addEventListener("change", function(){
    if(document.getElementById("AffichPoint").checked == false){
        document.getElementById("relic").checked = true;
    }
});

document.getElementById("A_clavier").addEventListener("change", function(event){
    if(document.getElementById("A_clavier").checked){
        document.getElementById("unitECLContainer").style.display = "block";
        document.getElementById("sampleratecontainer").style.display = "none";
        document.getElementById("Tdef").checked = false;
        document.getElementById("TdefContainer").style.display = "block";
    }else{
        document.getElementById("sampleratecontainer").style.display = "block";
        document.getElementById("unitECLContainer").style.display = "block";
    }
});
document.getElementById("Tdef").addEventListener("change", function(event){
    if(document.getElementById("Tdef").checked){
        document.getElementById("TdefContainer").style.display = "block";
        // document.getElementById("sampleratecontainer").style.display = "none";
        document.getElementById("A_clavier").checked = false;
        document.getElementById("unitECLContainer").style.display = "block";
    }else{
        // document.getElementById("sampleratecontainer").style.display = "block";
        document.getElementById("TdefContainer").style.display = "block";
    }
});
// function ChangeAcquisition(mode){
//     if(MODE_ACQUISITION != "clavier"){
//         MODE_ACQUISITION = mode;
//         document.getElementById("unitECLContainer").style.display = "block";
//         document.getElementById("ECLcontainer").style.display = "flex";
//     }else{
//         MODE_ACQUISITION = "reel";
//         document.getElementById("unitECLContainer").style.display = "none";
//         document.getElementById("ECLcontainer").style.display = "none";

//     }
// }
var values = [];  
document.getElementById("ECLcontainer").addEventListener("keypress", function(event){
    // console.log(event.key)
    if(event.key == "Enter"){
        validateECl();
    }
});
function validateECl(){
    let valueEcl = parseFloat(document.getElementById("txtECl").value); // Utiliser parseFloat pour gérer les décimales
    values.forEach(element => {
        feedGraphDataSets(element[0], valueEcl, element[1]);
        feedTab();
    });
    values = [];
    document.getElementById("txtECl").value = "";
}

function openParam(){
paramMenu = document.getElementsByClassName("wrapper")[0];
    
    paramMenu.classList.toggle("afficheP");
}
document.getElementById('coBtn').addEventListener('click', bleConnect);
document.getElementById('coBtnUSB').addEventListener('click', usbConnect);

function createConnectedElement(t){
    for(let i = 0; i <= ID_DEVICE.length; i++){
        if(ID_DEVICE[i] == null){
            ID_DEVICE[i] = i;
            const Newdiv = document.createElement("div");
            // const NewCC = document.createElement("div");
   
            const BScreen = document.createElement("div");
            const HeadSceen = document.createElement("div");
            const Elements1 = document.createElement("a");
            const Elements2 = document.createElement("img");
            const Elements4 = document.createElement("img");
            const Elements5 = document.createElement("img");
            const Elements3 = document.createElement("a");
            const Element6 = document.createElement("div");
            const NumSceen = document.createElement("div");

            BScreen.setAttribute("class", "DSH_AFFC");
            BScreen.setAttribute("id", ""+ID_DEVICE[i]+"");

            HeadSceen.setAttribute("class", "AFFC_H");
            
            Elements3.innerHTML = "ID: " + ID_DEVICE[i];
            Elements3.setAttribute("id", "idField" + ID_DEVICE[i]);

            Elements2.setAttribute("src", "ressource/lettre-x.svg");
            // Elements2.setAttribute("class", "regroupement");
            Elements2.setAttribute("class", "btnaxe");
            Elements2.setAttribute("id", "x"+ID_DEVICE[i]);
            Elements2.setAttribute("title", "Mettre l'appareil sur l'axe X");
            Elements2.setAttribute("onclick", "setXaxis("+ID_DEVICE[i]+")");
            Elements5.setAttribute("src", "ressource/lettre-y.svg");
            // Elements5.setAttribute("class", "regroupement");
            Elements5.setAttribute("class", "btnaxe lettrey");
            
            Elements5.setAttribute("title", "Mettre l'appareil sur l'axe Y");
            Elements5.setAttribute("id", "y"+ID_DEVICE[i]);
            Elements5.setAttribute("onclick", "setYaxis("+ID_DEVICE[i]+")");

            Element6.setAttribute("class", "roundlegende");
            Element6.setAttribute("id", "l" + ID_DEVICE[i]);
            // Elements2.setAttribute("onclick", "group("+ID_DEVICE[i]+")")

            Elements4.setAttribute("src", "ressource/deconnecter.svg");
            Elements4.setAttribute("title", "Déconnecter l'appareil");
            Elements4.setAttribute("class", "regroupement");
            Elements4.setAttribute("onclick", "windowDisconnect("+ID_DEVICE[i]+")")
            Newdiv.setAttribute("style", "width:50%;")
            Newdiv.setAttribute("id", "BtnContainer" + ID_DEVICE[i]);
            Newdiv.appendChild(Elements4);
            Newdiv.appendChild(Elements2);
            Newdiv.appendChild(Elements5);
            // Newdiv.appendChild(Element6);
            


            NumSceen.setAttribute("class", "AFFC_NUM");

            HeadSceen.appendChild(Elements3);
            HeadSceen.appendChild(Newdiv);
            HeadSceen.appendChild(Element6);

            NumSceen.appendChild(Elements1);

            BScreen.appendChild(HeadSceen);
            BScreen.appendChild(NumSceen);
            container.appendChild(BScreen);

            i = ID_DEVICE.length;
            document.getElementById("appareilfantome").style.display = "none";
            // document.getElementsByClassName("btnaxe").addEventListener("onclick", reInitChart());
            // setTimeout(() => {
            //     document.getElementById("x"+ID_DEVICE[i]).addEventListener("onclick", reInitChart());
            //     document.getElementById("y"+ID_DEVICE[i]).addEventListener("onclick", reInitChart());                
            // }, 300);
            if(t == "test"){
                NumSceen.childNodes[0].innerHTML = "8.1 pH"
            }
        }

    }

}

function windowDisconnect(id){
    if(window.confirm("Appareil ID: " + id + ", souhaitez-vous le déconnecter ?")){
        disconnect(id);
    }
}

// function group(id){
//     var groupid = null
//     groupid = window.prompt("Grouper l'"+id+" avec l'ID: ", "0");
//     // log(groupid)
//     groupid = parseInt(groupid);
//     if(groupid != undefined){
//         if(groupid != id){
//             if(Number.isInteger(parseInt(groupid))){
//                 // creategroup(id, groupid);
//             }else{
//                 window.alert("La valeur est incorrect !")
//             }
//         }else{
//             window.alert("L'ID renseigné est incorrect")
//         }
//     }
// }

// function renamegrp(id){
//     var newname = null
//     newname = window.prompt("Rennomer le groupe", "Paillasse 1");

//     document.getElementById("labelgrp" +id).innerHTML = newname;
// }

// function degroup(grp){
//     let groupID = new Array();
//     let group = grp.childNodes[1]
//     compteurgroupe--;
//     for(let i = 0; i < group.childNodes.length; i++){
//         groupID.push(group.childNodes[i].id);
//         document.getElementById("BtnContainer" + group.childNodes[i].id).style.display = "inline-block";
//         // document.getElementById("BtnContainer" + groupid).style.display = "none";
//     }
//     groupID.forEach(element => {
//         container.appendChild(document.getElementById(element)) 
//         setTimeout(() => {
//             groupID.splice(element)                 
//         }, 200);
//     });
//     grp.remove();


    
// }
// var compteurgroupe = 0;
// function creategroup(id, groupid){
//     compteurgroupe++;
//     const Newgroup = document.createElement("div");
//     const NewHeadGroup = document.createElement("div");
//     const elementHeada = document.createElement("a");
//     const elementHeadimg1 = document.createElement("img");
//     const elementHeadimg2 = document.createElement("img");

//     const Newgroupcont = document.createElement("div")

//     NewHeadGroup.setAttribute("class", "groupHead");

//     elementHeada.setAttribute("id", "labelgrp"+compteurgroupe);
//     elementHeada.innerHTML = "Paillasse "+compteurgroupe;

//     elementHeadimg1.setAttribute("onclick", "renamegrp('"+compteurgroupe+"')");
//     elementHeadimg2.setAttribute("onclick", "degroup(group"+compteurgroupe+")");
//     elementHeadimg2.setAttribute("class", "degroupimg");
//     elementHeadimg1.setAttribute("src", "/ressource/edit.svg" )
//     elementHeadimg2.setAttribute("src", "/ressource/croix.svg" )

//     Newgroupcont.setAttribute("class", "groupcont");
//     Newgroupcont.appendChild(document.getElementById(id));
//     Newgroupcont.appendChild(document.getElementById(groupid));





//     NewHeadGroup.appendChild(elementHeada);
//     NewHeadGroup.appendChild(elementHeadimg1);
//     NewHeadGroup.appendChild(elementHeadimg2);

    
//     Newgroup.setAttribute("class", "containergroup")
//     Newgroup.setAttribute("id", "group"+compteurgroupe+"")

//     Newgroup.appendChild(NewHeadGroup);
//     Newgroup.appendChild(Newgroupcont);


//     container.appendChild(Newgroup);

//     document.getElementById("BtnContainer" + id).style.display = "none";
//     document.getElementById("BtnContainer" + groupid).style.display = "none";
// }
function eraseConnectedElement(id){
    ID_DEVICE[id] = null;
    if(document.getElementById(id) != null)
        document.getElementById(id).remove();
}

function log(msg,seeLog=debug){
    if (seeLog)
        console.log(msg);
}



function connectDevice(device) {
    for (let i = 0; i < bluetoothDevice.length; i++) {
        // Si un emplacement est vide
        if (bluetoothDevice[i][1] === '') {
            bluetoothDevice[i][1] = device.id;
            bluetoothDevice[i][2] = device;

            console.log("bluetoothDevice", bluetoothDevice[i]);

            // Écouter la déconnexion
            device.addEventListener('gattserverdisconnected', function(event) {
                handleDisconnectEvent(event);
            });
            
            log("User picked a Bluetooth device. Connecting...");

            // Vérifiez si l'appareil est déjà connecté
            if (device.gatt && device.gatt.connected) {
                log("Déjà connecté à l'appareil.");
                return; // Sortir si déjà connecté
            }

            device.gatt.connect()
                .then(server => {
                    log("Connected");
                    bluetoothServer = server;
                    createConnectedElement();
                    log("Connected with ID: " + ID_DEVICE[i]);
                    document.getElementById("appareilfantome").style.display = "none";
                    
                    return initBLECharacteristics__(bluetoothServer, ID_DEVICE[i]);
                })
                .then(() => {
                    writeBLE(ID_DEVICE[i], "setBLE_ID(" + i + ")");
                })
                .catch(error => handleConnError("Connection error", ID_DEVICE[i], error));

            break; // Sortir de la boucle une fois connecté
        } else if (bluetoothDevice[i][1] === device.id) {
            window.alert("Appareil déjà connecté");
            break; // Sortir de la boucle si l'appareil est déjà connecté
        }
    }
}


let deviceBuffers = {};
function connectDeviceusb(device){
    let deviceId = null;

    // Parcourir les appareils USB connectés pour trouver un ID disponible
    for (let i = 0; i < bluetoothDevice.length; i++) {

        deviceId = i;
        //console.log("bluetoothDevice[i][2] :", bluetoothDevice[i][2]);
        console.log("device :", device);
        let device1 = port.device_;
        let serialNumber = device1.serialNumber;

        if (bluetoothDevice[i][1] === '') {

            bluetoothDevice[i][1] = serialNumber;

            bluetoothDevice[i][2] = device1;

            bluetoothDevice[i][3] = device;
            //console.log("device.serialNumber :", serialNumber);

            console.log("USBDevice", bluetoothDevice[i]);

            // Connexion du port WebUSB
            device.connect()
                .then(() => {
                    device.onReceive = null;
                    device.onReceiveError = null;
                    device.onDisconnect = null;
                    console.log("Port opened:", device);
                    device.id = deviceId; // Assigner l'ID à l'appareil

                    // Créer un élément visuel indiquant que le périphérique est connecté
                    createConnectedElement();

                    console.log("Connected with ID: ", deviceId);

                    document.getElementById("appareilfantome").style.display = "none";

                    // Définir les gestionnaires d'événements pour la réception de données et les erreurs
                    device.onReceive = data => {
                        let textDecoder = new TextDecoder();
                        let decodedText = textDecoder.decode(data);
                        // Ajouter les données reçues au buffer de l'appareil
                        deviceBuffers[serialNumber] += decodedText;
                        //console.log("deviceBuffers:",deviceBuffers,);
                            
                        // Traitement du buffer pour les messages complets
                        processBuffer(serialNumber);

                    };

                    device.onReceiveError = error => {
                        console.error("Receive error:", error);
                        handleDisconnect(device);

                    };
                })
                .catch(error => {
                    console.error("Connection error:", error);
                });

            break;


            // device.addEventListener('gattserverdisconnected', function(event) {
            //     handleDisconnectEvent(event);
            // }); 
            
        } 
        
        else if (bluetoothDevice[i][1] === serialNumber) {
            window.alert("Appareil déjà connecté");
            break;
            
        }
    }



}


function processBuffer(serialNumber) {
    let buffer = deviceBuffers[serialNumber]; // Récupérer le buffer de l'appareil
    let openParenCount = 0;
    let messageStartIndex = -1;
    
    for (let i = 0; i < buffer.length; i++) {
        if (buffer[i] === '(') {
            if (openParenCount === 0) {
                messageStartIndex = i;
            }
            openParenCount++;
        } else if (buffer[i] === ')') {
            openParenCount--;
            if (openParenCount === 0 && messageStartIndex !== -1) {
                let message = buffer.slice(messageStartIndex, i + 1);
                buffer = buffer.slice(i + 1); // Mettre à jour le buffer en enlevant le message traité
                deviceBuffers[serialNumber] = buffer; // Mettre à jour le buffer de l'appareil
                
                //console.log("Message complet extrait:", message);
                //console.log("Buffer restant:", buffer);

                // Vérifiez que le message extrait commence et se termine par une parenthèse
                if (message.startsWith('(') && message.endsWith(')')) {
                    // Traiter le message complet
                    processData(message, serialNumber);
                } else {
                    console.error("Message incomplet ou mal formé:", message);
                }

                // Réinitialiser pour traiter d'autres messages éventuels
                messageStartIndex = -1;
                i = -1; // Réinitialiser l'index pour traiter le nouveau buffer
            }
        }
    }
}

function processData(message, serialNumber) {
    //console.log("Message reçu:", message);

    // Extraction des données du format de tuple
    try {
        let parsedData = parseMessage(message);
        //console.log("Données analysées:", parsedData);

        if (parsedData) {
            for (let i = 0; i < bluetoothDevice.length; i++) {
                if( bluetoothDevice[i][1] === serialNumber ){

                    parsedData[2] = bluetoothDevice[i][0] ;
                
                }
                    
            }
            //console.log("JSON final:", parsedData);
            
            
            // Passer l'objet réorganisé à la fonction de gestion
            handleStreamDataOutNotifications2(parsedData);
        } else {
            console.error("Format de données invalide:", message);
        }
    } catch (error) {
        console.error("Erreur lors de l'analyse du message:", error);
    }
}

function parseMessage(message) {
    // Supprimer les parenthèses extérieures
    let strippedMessage = message.slice(1, -1);

    // Séparer les éléments principaux
    let mainParts = strippedMessage.split(/,\s*(?![^(]*\))/);
    
    // Fonction de remplacement des séquences d'échappement
    function replaceEscapedChars(str) {
        // Remplacer \xb0 par °
        return str.replace(/\\xb0/g, '°');
    }

    // Assurer que le quatrième élément est un tableau et le parser
    if (mainParts.length >= 4) {
        let parsedData = {
            0: replaceEscapedChars(mainParts[0].replace(/^'|'$/g, '').trim()),
            1: replaceEscapedChars(mainParts[1].replace(/^'|'$/g, '').trim()),
            2: replaceEscapedChars(mainParts[2].replace(/^'|'$/g, '').trim()),
            3: []
        };

        // Parse le quatrième élément
        let subArray = mainParts[3].slice(1, -1).split(/,\s*/);
        subArray.forEach(item => {
            let parsedItem = replaceEscapedChars(item.replace(/^'|'$/g, '').trim());
            // Vérifier si l'élément est numérique
            if (!isNaN(parsedItem)) {
                parsedItem = parseFloat(parsedItem);
            }
            parsedData[3].push(parsedItem);
        });

        // Ajouter les éléments supplémentaires s'il y en a
        for (let i = 4; i < mainParts.length; i++) {
            let additionalItem = replaceEscapedChars(mainParts[i].replace(/^'|'$/g, '').trim());
            parsedData[i] = additionalItem;
        }

        return parsedData;
    }

    return null;
}

// function processData(data) {
//     // Fonction de traitement des données reçues en WebUSB
//     console.log("Data received from WebUSB:", data);


//     handleStreamDataOutNotifications2(datadecode)
//     // Traitez les données reçues en fonction de leur format
// }

function writeBLE(id, string){
    const textEncoder = new TextEncoder();
    bluetoothDevice[id][3].writeValue(textEncoder.encode(string)).then(_ =>{
        console.warn("SUCCESS WRITING ON DEVICE :" + id);
    });
}

function bleConnect(){
        log("Calling the BLE device picker");
        if(ID_DEVICE[0] == null || ID_DEVICE[1] == null){

            let bleConf = {
                filters: [
                    {services:[FFF0ServiceUUID]},
                    {name:targetDeviceAdvName},
                    {namePrefix:targetDeviceAdvName}
                ]
            }			
            navigator.bluetooth.requestDevice(bleConf).then(device => {
                if (device != null)
                    connectDevice(device);
            }).catch(error => {
                log(error);
                log("User canceled");
            });
        }else{
            window.alert("Limite d'appareils atteinte")
        }

        		

}

function usbConnect(){
    log("Calling the USB device picker");
    if(ID_DEVICE[0] == null || ID_DEVICE[1] == null){
    
        			
        serial.requestPort().then(selectedPort => {
            if (selectedPort != null)
                port = selectedPort;
                connectDeviceusb(port = selectedPort);
        }).catch(error => {
            log(error);
            log("User canceled");
        });
    }else{
        window.alert("Limite d'appareils atteinte")
    }

            

}

// function initBLECharacteristics__(server, id){
	
// 	// console.log(id)
//     log("Getting FFF0ServiceUUID...");
//     server.getPrimaryService(FFF0ServiceUUID).then(service => {
//         log("got FFF0ServiceUUID...");
//         FFF0ServiceObj = service;
//         // bluetoothDevice[id][3] = service;
//         // console.log(id)
//         log("Getting uartRxcharacteristicUUID...");
//         FFF0ServiceObj.getCharacteristic(uartTxcharacteristicUUID).then(characteristic =>{
//             bluetoothDevice[id][3] = characteristic;
//             // characteristic.write(decoder.encoding("setBLE_ID(1)"));
//             log("got uartTxCharacteristicObj...");

//             FFF0ServiceObj.getCharacteristic(uartRxcharacteristicUUID).then(characteristic =>{
        
//                 bluetoothDevice[id][4] = characteristic;
//                 log("got uartRxCharacteristicObj...");
//                 uartRxCharacteristicObj = characteristic;
    
                        
//                 uartRxCharacteristicObj.startNotifications().then(_ =>{

//                     log("All done...");
//                     uartRxCharacteristicObj.addEventListener('characteristicvaluechanged',handleStreamDataOutNotifications);
//                     notifyUI_DevReady(true);
//                 }).catch(error => handleConnError("Unable to start notification : "+error, id));									
            
            
//              }).catch(error => handleConnError("Unable to get uartRxcharacteristicUUID characteristic : "+error, id));
//         }).catch(error => handleConnError("Unable to get uartTxcharacteristicUUID : "+error, id));
//     }).catch(error => handleConnError("Unable to get server: "+error, id));


// }

var uartRxCharacteristicObj;
function initBLECharacteristics__(server, id){
    return new Promise((resolve, reject) => {
    // console.log(id)
        log("Getting FFF0ServiceUUID...");
        server.getPrimaryService(FFF0ServiceUUID).then(service => {
            log("got FFF0ServiceUUID...");
            FFF0ServiceObj = service;
            // bluetoothDevice[id][3] = service;
            // console.log(id)
            log("Getting uartRxcharacteristicUUID...");
            FFF0ServiceObj.getCharacteristic(uartTxcharacteristicUUID).then(characteristic =>{
                bluetoothDevice[id][3] = characteristic;
                // characteristic.write(decoder.encoding("setBLE_ID(1)"));
                log("got uartTxCharacteristicObj...");

                FFF0ServiceObj.getCharacteristic(uartRxcharacteristicUUID).then(characteristic =>{
            
                    bluetoothDevice[id][4] = characteristic;
                    log("got uartRxCharacteristicObj...");
                    uartRxCharacteristicObj = characteristic;
        
                            
                    uartRxCharacteristicObj.startNotifications().then(_ =>{
                        resolve("AllDone");

                        log("All done...");
                        // if(isstart == true){
                            uartRxCharacteristicObj.addEventListener('characteristicvaluechanged',handleStreamDataOutNotifications);
                        // }
                        notifyUI_DevReady(true);
                    }).catch(error => handleConnError("Unable to start notification : "+error, id));									
                }).catch(error => handleConnError("Unable to get uartRxcharacteristicUUID characteristic : "+error, id));
            }).catch(error => handleConnError("Unable to get uartTxcharacteristicUUID : "+error, id));
        }).catch(error => handleConnError("Unable to get server: "+error, id));

    });	
}

window.onbeforeunload = function(){
    for(let i = 0; i <= bluetoothDevice.length; i++)
        disconnect(i);
}



function notifyUI_DevReady(sta){
    log("notifyUI_DevReady")
    log(sta)
}

function handleDisconnectEvent(event) {
    log("BLE device déconnecté !");
    stop();

    for (let i = 0; i < bluetoothDevice.length; i++) {
        if (bluetoothDevice[i][1] == event.target.id) {
            console.warn("Tentative de reconnexion...");

            setTimeout(() => {
                // Vérifie si l'appareil est toujours déconnecté
                if (!bluetoothDevice[i][2].gatt.connected) {
                    console.warn("Reconnexion échouée, suppression de l'appareil...");
                    resetBleObj(i);
                    eraseConnectedElement(i);
                    window.alert("Appareil ID : " + i + " déconnecté !");
                } else {
                    console.log("Reconnexion réussie !");
                }
            }, 3000); // Attend 3 secondes avant d'effacer l'appareil

            break;
        }
    }
}


function handleDisconnect(device){
    log("USB device get disconnected !");
    stop();
    // console.log(event.target.id)
    for(let i = 0; i < bluetoothDevice.length; i++){
        if(bluetoothDevice[i][3] === device ){
            let serialNumber = bluetoothDevice[i][1];
            resetBleObj(i);
            eraseConnectedElement(i);
            deviceBuffers[serialNumber] = {} ;
            // disconnect(i);
            window.alert("Appareil ID : " + i + " déconnecté !")
            break;
        }
    }
    
}


function handleConnError(msg, id){
    log("Error while configuring ("+msg+").\nDisconnecting");
    console.log(id)
    disconnect(id);
    // console.warn(id);
    // if(!isNaN(id))
    //     disconnect(id);
}

async function disconnect(device){
    // console.log(device)
    // if(window.confirm("Appareil ID: " + device + ", souhaitez-vous le déconnecter ?")){
    

    // if (bluetoothDevice[device][2].opened && bluetoothDevice[device][1] != "") {
    //     // Code à exécuter si l'appareil est ouvert et si le nom du produit n'est pas vide
    //     console.log("L'appareil WebUSB est ouvert et le nom du produit n'est pas vide.");
    // } else {
    //     // Code à exécuter si l'une des conditions n'est pas remplie
    //     console.log("L'appareil WebUSB n'est pas ouvert ou le nom du produit est vide.");
    // }

    //console.log(device)
    //console.log("bluetoothDevice :", bluetoothDevice[device][2]);
    stop();
    if (bluetoothDevice[device][2] instanceof USBDevice) {
        
        if (bluetoothDevice[device][2].opened && bluetoothDevice[device][1] != ""){
            // console.warn(bluetoothDevice[device][2]); 
            await bluetoothDevice[device][3].disconnect();
            let serialNumber = bluetoothDevice[device][1]
            //port = null;
            eraseConnectedElement(device);
            // device.gatt.disconnect();
            console.log("Disconnecting...");
            resetBleObj(device);
            console.log("Disconnected");
            deviceBuffers[serialNumber] = {};			

        }else{
            // resetBleObj(device);
            // console.log("already disconnected");
            // eraseConnectedElement(device);
            console.log("Erreur déconnection")
        }
    }
    else if (bluetoothDevice[device][2] instanceof BluetoothDevice){
        if (bluetoothServer != null && bluetoothDevice[device][2].gatt.connected && bluetoothDevice[device][1] != ""){
            // console.warn(bluetoothDevice[device][2]); 
                bluetoothDevice[device][2].gatt.disconnect();
                eraseConnectedElement(device);
                // device.gatt.disconnect();
                console.log("Disconnecting...");
                resetBleObj(device);
                console.log("Disconnected");			
    
            }else{
                // resetBleObj(device);
                // console.log("already disconnected");
                // eraseConnectedElement(device);
                console.log("Erreur déconnection")
        }
    }
       
        // disconnect(i);
    // }
	// for(let i = 0; i <= bluetoothDevice.length ; i++){
    //     if (bluetoothServer != null && bluetoothServer.connected && bluetoothDevice[device][2] != ""){
    //     // console.warn(bluetoothDevice[device][2]); 
    //         bluetoothDevice[device][2].gatt.disconnect();
    //         eraseConnectedElement(device);
    //         // device.gatt.disconnect();
    //         log("Disconnecting...");
    //         resetBleObj(device);
    //         log("Disconnected");			

    //     }else{
    //         resetBleObj(device);
    //         log("already disconnected");
    //         eraseConnectedElement(device);
    // }

}

function resetBleObj(index){
    // bluetoothDevice[index][0] = null;
    if(index != null){
        bluetoothDevice[index][1] = "";
        bluetoothDevice[index][2] = "";
        bluetoothDevice[index][3] = "";
        //bluetoothDevice[index][4] = "";
        // bluetoothServer = 
        // FFF0ServiceObj = 
        // uartRxCharacteristicObj = 
        // uartTxCharacteristicObj = null;        
    }
    if((bluetoothDevice[0][1] == '') && (bluetoothDevice[1][1] == '')){
    // if((bluetoothDevice[0][1] == '') && (bluetoothDevice[1][1] == '') && (bluetoothDevice[2][1] == '') && (bluetoothDevice[3][1] == '')){
        document.getElementById("appareilfantome").style.display = "flex";
    }
}


var startTimer = 0;
var passfirst = false;
var isstart = false;
var dataArray = [null, null];
// var dataArray = [null, null, null, null];
var previousValue = null;

var lastticks = 0;
var ticms = 0;
var myLinecolo = null;
var myLinecolo2 = null;
var datacanvcolo = null;
function handleStreamDataOutNotifications(event) {
        // var time = Date.now()
        let value = event.target.value;
        
        // let dataA = new Array();
        // if(passfirst == false){
        //     passfirst = true;
        //     startTimer = Date.now();	
        // }else if(deviceOnGraph[0] == null && deviceOnGraph[1] == null ){
        // // }else if(deviceOnGraph[0] == null && deviceOnGraph[1] == null && deviceOnGraph[2] == null && deviceOnGraph[3] == null ){
        //     passfirst = false;
        // }
        /*
        let a = [];
        for (let i = 0; i < value.byteLength; i++) {
        a.push('0x' + ('00' + value.getUint8(i).toString(16)).slice(-2));
        }
        console.log('> ' + a.join(' '));
        */
        
        let jsonResult = null;
        let decoderValue = "";
        try {
          decoderValue = decoder.decode(value);
          //console.log("decoderValue :", decoderValue);

            try {
                jsonResult = JSON.parse(decoderValue);
                //console.log("jsonResult :", jsonResult);
            } catch (error) { jsonResult = null; }
        } catch (error) { jsonResult = null; }
        //console.log("jsonResult",jsonResult);
        if ( jsonResult != null ){
            for(let i = 0; i <= bluetoothDevice.length-1; i++){
                // console.log(bluetoothDevice[i])
                //console.log("bluetoothDevice", bluetoothDevice[i][1])
                if(bluetoothDevice[i][1] != ''){
                    // console.log(bluetoothDevice[i])
                    if(jsonResult[2] == bluetoothDevice[i][0]){
                        
                        if(jsonResult[0] == "304005" && jsonResult[5] == 0){
                            // if(myLinecolo != null){
                                // console.log("Colorimetre")
                                
                                // myLinecolo = new Chart(coloctx, configcolo);  

                                // }else{
                                let idcanv = "graphcolo" + jsonResult[2];
                                // console.log(idcanv)

                                if(document.getElementById(idcanv) == null){
                                    document.getElementById(bluetoothDevice[i][0]).childNodes[1].childNodes[0].innerHTML = "";
                                    if(document.getElementById("labelnm")!=null){
                                        document.getElementById("labelnm").remove();
                                    }
                                    var canv = document.createElement("canvas");
                                    canv.setAttribute("id", idcanv);
                                    document.getElementById(bluetoothDevice[i][0]).childNodes[1].appendChild(canv);
                                }else{
                                    if(jsonResult[2] == 0){
                                        myLinecolo.destroy();

                                    }else if(jsonResult[2] == 1){
                                        myLinecolo2.destroy();

                                    }
                                }
                                document.getElementById(bluetoothDevice[i][0]).childNodes[1].setAttribute("style", "gap:0rem");

                                let coloctx = document.getElementById(idcanv).getContext("2d"); 
                                // console.log("Colorimetre")

                                if(jsonResult[4] == "A"){
                                    configcolo.options.scales.y.max = 3;
                                    configcolo.options.scales.y.min = 0;
                                    datacolo.datasets[0].label = "Absorbance";
                                }else{
                                    configcolo.options.scales.y.max = 100;
                                    datacolo.datasets[0].label = "Transmittance";
                                    configcolo.options.scales.y.min = 0;
                                }
                                // console.log(jsonResult)
                                for(let i = 0; i <= 8; i++){
                                    datacolo.datasets[0].data[i] = jsonResult[3][i];

                                }
                                if(jsonResult[2] == 0){
                                    myLinecolo = new Chart(coloctx, configcolo);
                                    myLinecolo.update();


                                }else if(jsonResult[2] == 1){
                                    myLinecolo2 = new Chart(coloctx, configcolo);
                                    myLinecolo2.update();


                                }

                            // }
                        }else{
                            let idcanv = "graphcolo" + jsonResult[2];
                            if(document.getElementById(idcanv) != null){
                                document.getElementById(idcanv).remove();
                            }
                            if(jsonResult[0] == "304005"){
                                if(jsonResult[2] == 0){
                                    labelnm = document.createElement("a");  
                                    labelnm.setAttribute("id", "labelnm");
                                    if(document.getElementById("labelnm") == null){
                                        document.getElementById(bluetoothDevice[i][0]).childNodes[1].appendChild(labelnm);
                                        document.getElementById(bluetoothDevice[i][0]).childNodes[1].setAttribute("style", "gap:3rem");
    
                                    }
                                    document.getElementById("labelnm").innerHTML = "λ : " + jsonResult[3][2] + " nm"

                                }else if(jsonResult[2] == 1){
                                    labelnm1 = document.createElement("a");  
                                    labelnm1.setAttribute("id", "labelnm1");
                                    if(document.getElementById("labelnm1") == null){
                                        document.getElementById(bluetoothDevice[i][0]).childNodes[1].appendChild(labelnm1);
                                        document.getElementById(bluetoothDevice[i][0]).childNodes[1].setAttribute("style", "gap:3rem");
    
                                    }
                                    document.getElementById("labelnm1").innerHTML = "λ : " + jsonResult[3][2] + " nm"
                                }



                                // labelnm = document.getElementById(bluetoothDevice[i][0]).childNodes[1].createElement("a");  
                            }

                            document.getElementById(bluetoothDevice[i][0]).childNodes[1].childNodes[0].innerHTML = parseFloat(jsonResult[3][0]).toFixed(2) + " "+jsonResult[3][1];

                        }

                        
                
                        if (MODE_ACQUISITION == "reel") {
                            // console.log("bluetoothDevice:", bluetoothDevice[i][0]);
                            // console.log("jsonResult:",jsonResult);
                            // Vérifier si deviceOnGraphX n'est pas null
                            if (deviceOnGraphX != null) {
                                if (dataArray[i] != null) {
                                    // Si dataArray[i] existe et que l'appareil est sur le graphique, mettre à jour la valeur
                                    if (dataArray[i][1] == deviceOnGraphX) {
                                        //console.log("step1");
                                        dataArray[i][0] = parseFloat(jsonResult[3][0]).toFixed(2);
                                    }
                                } else {
                                    // Si dataArray[i] n'existe pas, créer une nouvelle entrée si l'appareil est sur le graphique
                                    if (jsonResult[2] == deviceOnGraphX) {
                                        //console.log("step2");
                                        dataArray[i] = [parseFloat(jsonResult[3][0]).toFixed(2), jsonResult[2], jsonResult[3][1]];
                                    }
                                }
                            }
                        
                            // Vérifier si deviceOnGraph[i] n'est pas null
                            if (deviceOnGraph[i] != null) {
                                // console.log("bluetoothDevice:", bluetoothDevice[i][0]);
                                // console.log("jsonResult:",jsonResult);
                                // console.log("step41");
                                if (dataArray[i] != null) {
                                    //console.log("step42");
                                    if (i < compteurDeviceOnGraph) {
                                        deviceOnGraph.forEach(element => {
                                            if (element != null) {
                                                // Si l'élément du graphique correspond à l'appareil, mettre à jour la valeur
                                                if (element == dataArray[i][1]) {
                                                    if (parseFloat(jsonResult[3][0]) != dataArray[i][0]) {
                                                        //console.log("step3");
                                                        dataArray[i][0] = parseFloat(jsonResult[3][0]).toFixed(2);
                                                    }
                                                }
                                            }
                                        });
                                    }
                                } else {
                                    deviceOnGraph.forEach(element => {
                                        // console.log("step43");
                                        // console.log("bluetoothDevice:", bluetoothDevice[i][0]);
                                        // console.log("jsonResult:",jsonResult);
                                        // console.log("element:",element);
                                        // Si l'appareil correspond à l'élément du graphique, créer une nouvelle entrée
                                        if (jsonResult[2] == element) {
                                            //console.log("step44");
                                            dataArray[i] = [parseFloat(jsonResult[3][0]).toFixed(2), jsonResult[2], jsonResult[3][1]];
                                        }
                                    });
                                }
                            }
                        }
                        
                                else if(MODE_ACQUISITION == "clavier"){
                                // let val = [parseFloat(jsonResult[3][0]), deviceOnGraph[i]];
                                let value = 0;
                                if(deviceOnGraph[0] == jsonResult[2]){
                                    value = [parseFloat(jsonResult[3][0]), jsonResult[2]];
                                    if(values.length != 0){
                                        values.forEach(element => {
                                            // console.log(element)
                                            if(element[1] != value[1]){
                                                if(compteurDeviceOnGraph > values.length){
                                                    values.push(value);
                                                }
        
                                            }else{
                                                if(element[0] != value[0]){
                                                    element[0] = value[0];
                                                }
                                            }
        
                                        });
                                    }else{
                                        values.push(value);
        
                                    }
                                }
                                
    
                                
    
                            }
    
                            // }
                        // }
    
                        
                        // console.log("true")
                    }
                }
    
            }
            // console.log(dataArray)
        }
        // console.log("ouii")
            
    
    
}

function handleStreamDataOutNotifications2(data) {
    // var time = Date.now()
    //let value = event.target.value;
    // let dataA = new Array();
    // if(passfirst == false){
    //     passfirst = true;
    //     startTimer = Date.now();	
    // }else if(deviceOnGraph[0] == null && deviceOnGraph[1] == null ){
    // // }else if(deviceOnGraph[0] == null && deviceOnGraph[1] == null && deviceOnGraph[2] == null && deviceOnGraph[3] == null ){
    //     passfirst = false;
    // }
    /*
    let a = [];
    for (let i = 0; i < value.byteLength; i++) {
        a.push('0x' + ('00' + value.getUint8(i).toString(16)).slice(-2));
    }
    console.log('> ' + a.join(' '));
    */
    
    let jsonResult = null;
    //let decoderValue = "";


    
    jsonResult = data;
    
  

    //console.log("jsonResult", jsonResult)

    if ( jsonResult != null ){
        for(let i = 0; i <= bluetoothDevice.length-1; i++){
            // console.log(bluetoothDevice[i])
            //console.log("bluetoothDevice", bluetoothDevice[i][1])
            if(bluetoothDevice[i][1] != ''){
                //console.log(bluetoothDevice[i][0])
                //console.log("jsonResult2", jsonResult[2])
                if(jsonResult[2] == bluetoothDevice[i][0]){
                    //console.log("jsonResult2", jsonResult)
                    if(jsonResult[0] == "304005" && jsonResult[5] == 0){
                        // if(myLinecolo != null){
                            // console.log("Colorimetre")
                            
                            // myLinecolo = new Chart(coloctx, configcolo);  

                            // }else{
                            let idcanv = "graphcolo" + jsonResult[2];
                            // console.log(idcanv)

                            if(document.getElementById(idcanv) == null){
                                document.getElementById(bluetoothDevice[i][0]).childNodes[1].childNodes[0].innerHTML = "";
                                if(document.getElementById("labelnm")!=null){
                                    document.getElementById("labelnm").remove();
                                }
                                var canv = document.createElement("canvas");
                                canv.setAttribute("id", idcanv);
                                document.getElementById(bluetoothDevice[i][0]).childNodes[1].appendChild(canv);
                            }else{
                                if(jsonResult[2] == 0){
                                    myLinecolo.destroy();

                                }else if(jsonResult[2] == 1){
                                    myLinecolo2.destroy();

                                }
                            }
                            document.getElementById(bluetoothDevice[i][0]).childNodes[1].setAttribute("style", "gap:0rem");

                            let coloctx = document.getElementById(idcanv).getContext("2d"); 
                            // console.log("Colorimetre")

                            if(jsonResult[4] == "A"){
                                configcolo.options.scales.y.max = 3;
                                configcolo.options.scales.y.min = 0;
                                datacolo.datasets[0].label = "Absorbance";
                            }else{
                                configcolo.options.scales.y.max = 100;
                                datacolo.datasets[0].label = "Transmittance";
                                configcolo.options.scales.y.min = 0;
                            }
                            // console.log(jsonResult)
                            for(let i = 0; i <= 8; i++){
                                datacolo.datasets[0].data[i] = jsonResult[3][i];

                            }
                            if(jsonResult[2] == 0){
                                myLinecolo = new Chart(coloctx, configcolo);
                                myLinecolo.update();


                            }else if(jsonResult[2] == 1){
                                myLinecolo2 = new Chart(coloctx, configcolo);
                                myLinecolo2.update();


                            }

                        // }
                    }else{
                        let idcanv = "graphcolo" + jsonResult[2];
                        if(document.getElementById(idcanv) != null){
                            document.getElementById(idcanv).remove();
                        }
                        if(jsonResult[0] == "304005"){
                            if(jsonResult[2] == 0){
                                labelnm = document.createElement("a");  
                                labelnm.setAttribute("id", "labelnm");
                                if(document.getElementById("labelnm") == null){
                                    document.getElementById(bluetoothDevice[i][0]).childNodes[1].appendChild(labelnm);
                                    document.getElementById(bluetoothDevice[i][0]).childNodes[1].setAttribute("style", "gap:3rem");

                                }
                                document.getElementById("labelnm").innerHTML = "λ : " + jsonResult[3][2] + " nm"

                            }else if(jsonResult[2] == 1){
                                labelnm1 = document.createElement("a");  
                                labelnm1.setAttribute("id", "labelnm1");
                                if(document.getElementById("labelnm1") == null){
                                    document.getElementById(bluetoothDevice[i][0]).childNodes[1].appendChild(labelnm1);
                                    document.getElementById(bluetoothDevice[i][0]).childNodes[1].setAttribute("style", "gap:3rem");

                                }
                                document.getElementById("labelnm1").innerHTML = "λ : " + jsonResult[3][2] + " nm"
                            }



                            // labelnm = document.getElementById(bluetoothDevice[i][0]).childNodes[1].createElement("a");  
                        }

                        document.getElementById(bluetoothDevice[i][0]).childNodes[1].childNodes[0].innerHTML = parseFloat(jsonResult[3][0]).toFixed(2) + " "+jsonResult[3][1];

                    }
                    if (MODE_ACQUISITION == "reel") {
                        // Vérifier si deviceOnGraphX n'est pas null
                        if (deviceOnGraphX != null) {
                            if (dataArray[i] != null) {
                                // Si dataArray[i] existe et que l'appareil est sur le graphique, mettre à jour la valeur
                                if (dataArray[i][1] == deviceOnGraphX) {
                                    //console.log("step1");
                                    dataArray[i][0] = parseFloat(jsonResult[3][0]).toFixed(2);
                                }
                            } else {
                                // Si dataArray[i] n'existe pas, créer une nouvelle entrée si l'appareil est sur le graphique
                                if (jsonResult[2] == deviceOnGraphX) {
                                    //console.log("step2");
                                    dataArray[i] = [parseFloat(jsonResult[3][0]).toFixed(2), jsonResult[2], jsonResult[3][1]];
                                }
                            }
                        }
                    
                        // Vérifier si deviceOnGraph[i] n'est pas null
                        if (deviceOnGraph[i] != null) {
                            if (dataArray[i] != null) {
                                if (i < compteurDeviceOnGraph) {
                                    deviceOnGraph.forEach(element => {
                                        if (element != null) {
                                            // Si l'élément du graphique correspond à l'appareil, mettre à jour la valeur
                                            if (element == dataArray[i][1]) {
                                                if (parseFloat(jsonResult[3][0]) != dataArray[i][0]) {
                                                    //console.log("step3");
                                                    dataArray[i][0] = parseFloat(jsonResult[3][0]).toFixed(2);
                                                }
                                            }
                                        }
                                    });
                                }
                            } else {
                                deviceOnGraph.forEach(element => {
                                    // Si l'appareil correspond à l'élément du graphique, créer une nouvelle entrée
                                    if (jsonResult[2] == element) {
                                        //console.log("step4");
                                        dataArray[i] = [parseFloat(jsonResult[3][0]).toFixed(2), jsonResult[2], jsonResult[3][1]];
                                    }
                                });
                            }
                        }
                    }
                    
                            else if(MODE_ACQUISITION == "clavier"){
                            // let val = [parseFloat(jsonResult[3][0]), deviceOnGraph[i]];
                            let value = 0;
                            if(deviceOnGraph[0] == jsonResult[2]){
                                value = [parseFloat(jsonResult[3][0]), jsonResult[2]];
                                if(values.length != 0){
                                    values.forEach(element => {
                                        // console.log(element)
                                        if(element[1] != value[1]){
                                            if(compteurDeviceOnGraph > values.length){
                                                values.push(value);
                                            }
    
                                        }else{
                                            if(element[0] != value[0]){
                                                element[0] = value[0];
                                            }
                                        }
    
                                    });
                                }else{
                                    values.push(value);
    
                                }
                            }
                            

                            

                        }

                        // }
                    // }

                    
                    // console.log("true")
                }
            }

        }
        // console.log(dataArray)
    }
    // console.log("ouii")
        


}


function feedgraphdataxy(arr){
    // console.log(arr);
    let x = 0;
    let y = 0;
    let id;
    dataArray.forEach(element => {
        deviceOnGraph.forEach(elementY => {
            if(elementY != null){
                if(element[0] == deviceOnGraphX){
                    x = element[1];
                }else if( element[0] == elementY){
                    y = element[1];
                    id = elementY;
                }    
        }
        });

    });
    feedGraphDataSets(y, x, id);
    // console.log(y, x)   
    dataArray = new Array();

    
}
var deviceOnGraphX = null;
var compteurDeviceOnGraph = 0;

function setXaxis(id){
    if(isstart == false){
        if(!deviceOnGraph.includes(id)){
            let unit = document.getElementById(id).childNodes[1].childNodes[0].text.split(" ")[1];
        
        
            if(deviceOnGraphX == null){
                deviceOnGraphX = id;
                config.options.scales.xAxes.title.text = 'ID: '+ id+ ' (en '+unit + ')';
                config.options.scales.xAxes.color = "#b40804";
                document.getElementById("l" + id).style.backgroundColor = "#b40804";
                document.getElementById("l" + id).innerHTML = "x";
                compteurDeviceOnGraph++;
            }else if(deviceOnGraphX != null){
                if(deviceOnGraphX == id){
                    deviceOnGraphX = null;
                    config.options.scales.xAxes.title.text = 'Temps (en s)';
                    config.options.scales.xAxes.color = "";
                    document.getElementById("l" + id).innerHTML = "";
                    document.getElementById("l" + id).style.backgroundColor = "#ffffff";
                    compteurDeviceOnGraph--;
                }else{
                    window.alert("Axe X déjà initialisé");
                }
            }
            reInitChart();
        }else{
            window.alert("Appareil déjà initialisé sur l'axe Y");
        }

    }else{
        window.alert("Action impossible tant que l'acquisition est lancée !")
    }
}

var tacontainer = document.getElementById("tab")

function inittab(){
    let theadinit = document.createElement("thead");
    let th = document.createElement("th");
    let trinit = document.createElement("tr");
    trinit.setAttribute("id", "trheader");
    th.innerHTML = "&nbsp;";
    trinit.appendChild(th);
    theadinit.appendChild(trinit);
    theadinit.setAttribute("id", "headertab");
    tacontainer.appendChild(theadinit);
    
    let tbodyaxis = document.createElement("tbody");
    let th2 = document.createElement("th");
    tbodyaxis.setAttribute("id", "tbodyaxis");
    th2.innerHTML = "Axe x";
    let traxis = document.createElement("tr");
    traxis.setAttribute("id", "traxis");
    
    traxis.appendChild(th2);
    tbodyaxis.appendChild(traxis);
    tacontainer.appendChild(tbodyaxis)
    
}


document.getElementById("closetabcontainer").addEventListener('click', function(){
    document.getElementById("tabContainer").style.display = "none";
});

var deviceOnGraph = [-1, -1 ];
// var deviceOnGraph = [null,null ,null, null ];
var borderColors = ['#c48715','#00bbf0','#289827','#c3195d'];

function setYaxis(uid){
    if(isstart == false){
        for(let i = 0; i <= document.getElementsByClassName("lettrey").length-1; i++){
            document.getElementsByClassName("lettrey")[i].setAttribute("class", "regroupement lettrey")
        } 
        if(deviceOnGraphX != uid){
            document.getElementById("btnTab").style.display = "block";
            let unit = document.getElementById(uid).childNodes[1].childNodes[0].text.split(" ")[1];
            let min = 0;
            let max = 100;
            switch (unit) {
                case "pH":
                        min = 0;
                        max = 14;
                    break;
                case "°C":
                        min = -25;
                        max = 125;
                    break;
                case "°F":
                        min = -13;
                        max = 257;
                    break;
                case "K":
                        min = 248;
                        max = 398;
                    break;
                case "hPa":
                        min = -1000;
                        max = 2000;
                    break;
                case "mBar":
                        min = -1000;
                        max = 2000;
                    break;
                case "A":
                    min = 0;
                    max = 3;
                    break;
                case "T":
                    min = 0;
                    max = 100;
                    break;                 
                default:
                    break;
            }

            let elementindex = 0;
            let colorid = 0;
            
            for(let i = 0; i <= deviceOnGraph.length-1; i++){
                
                //console.log("i",i);
                //console.log("!deviceOnGraph.includes(uid)",!deviceOnGraph.includes(uid))
                if(deviceOnGraph[i] == -1 && !deviceOnGraph.includes(uid)){
                    elementindex = i;
                    //console.log(i)
                    deviceOnGraph[i] = uid;

                    //console.log("i",i);
                    //console.log("deviceOnGraph",deviceOnGraph);
                    colorid = elementindex;  
                    compteurDeviceOnGraph++;
                    document.getElementById("l" + uid).style.backgroundColor = borderColors[colorid];
                    document.getElementById("l" + uid).innerHTML = "y";
                    switch (elementindex) {
                        case 0:
                            config.options.scales.yAxes0.display = true;
                            config.options.scales.yAxes0.title.text = unit;
                            config.options.scales.yAxes0.color = borderColors[colorid];    
                            config.options.scales.yAxes0.min = min;    
                            config.options.scales.yAxes0.max = max;    
                            break;
                        case 1:
                            config.options.scales.yAxes1.display = true;
                            config.options.scales.yAxes1.title.text = unit;
                            config.options.scales.yAxes1.color = borderColors[colorid];
                            config.options.scales.yAxes1.min = min;    
                            config.options.scales.yAxes1.max = max;                                
                            break;
                        // case 2:
                        //     config.options.scales.yAxes2.display = true;
                        //     config.options.scales.yAxes2.title.text = unit;
                        //     config.options.scales.yAxes2.color = borderColors[colorid];
                        //     config.options.scales.yAxes2.min = min;    
                        //     config.options.scales.yAxes2.max = max;                                
                        //     break;
                        // case 3:
                        //     config.options.scales.yAxes3.display = true;
                        //     config.options.scales.yAxes3.title.text = unit;
                        //     config.options.scales.yAxes3.color = borderColors[colorid];
                        //     config.options.scales.yAxes3.min = min;    
                        //     config.options.scales.yAxes3.max = max;                                
                        //     break;
                    
                        default:
                            break;
                    }
                    let tr = document.getElementById("trheader");
                    let th = document.createElement("th");
                    let thead = document.getElementById("headertab");
                    let thaxis2 = document.createElement("th");


                    th.innerHTML = unit + ' (ID: '+ uid+ ')';
                    th.setAttribute("id", "header"+uid)
                    tr.appendChild(th);
                    thead.appendChild(tr);
                    thaxis2.innerHTML = "Axe y";
                    thaxis2.setAttribute("id", "yax"+uid);

                    document.getElementById("traxis").appendChild(thaxis2);

                    config.data.datasets.push({
                        label: unit + ' (ID: '+ uid+ ')',
                        yAxisID: "yAxes" + uid,
                        tension: 0.3,
                        fill: false,
                        showLine: false,
                        borderColor: borderColors[colorid],
                        backgroundColor: borderColors[colorid],
                    }); 
                }
                else if(deviceOnGraph[i] != null && deviceOnGraph.includes(uid)){
                    if(deviceOnGraph[i] == uid){
                        compteurDeviceOnGraph--;
                        document.getElementById("l" + uid).style.backgroundColor = "#ffffff";
                        document.getElementById("l" + uid).innerHTML = "";

                        switch (deviceOnGraph.indexOf(uid)) {
                            case 0:
                                config.options.scales.yAxes0.display = false;
                                break;
                            case 1:
                                config.options.scales.yAxes1.display = false;    

                                break;
                            // case 2:
                            //     config.options.scales.yAxes2.display = false;     

                            //     break;
                            // case 3:
                            //     config.options.scales.yAxes3.display = false;     

                            //     break;
                        
                            default:

                                break;
                        };

                        if(compteurDeviceOnGraph == 0){
                            document.getElementById("btnTab").style.display = "none"

                        }
                        document.getElementById("yax" +uid).remove();
                        document.getElementById("header" +uid).remove();

                        config.data.datasets.forEach(element2 => {
                            let idData = Number(element2.yAxisID.replace(/[^\d]/g, ""));
                            if(idData == deviceOnGraph[i]){
                                config.data.datasets.splice(config.data.datasets.indexOf(element2),1);
                                deviceOnGraph[i] = -1;
                                //console.log(deviceOnGraph);
                                return;
                            }

                        });
                        break;
                    }
                }
                
            }
            
            reInitChart();   
        }else{
            window.alert("Appareil déjà initialisé sur l'axe X !");
        }

    }else{
        window.alert("Action impossible tant que l'acquisition est lancée !")
    }

}
function openTab(){
    document.getElementById("tabContainer").style.display = "block";

}
Chart.defaults.font.size = 16;

function getRandomInt(max) {
    return Math.floor(Math.random() * max);
  }

var compt2 = 0;
var intervID = null;
function start(){
    //console.log("feedTab3");
    if(bluetoothDevice[0][1] != '' || bluetoothDevice[1][1] != ''){
        //console.log("feedTab3");
        if(deviceOnGraph[0] != -1 || deviceOnGraph[1] !=-1){
            //console.log("feedTab3");

            isstart = true;
                // handleStreamDataOutNotifications('characteristicvaluechanged');
                // uartRxCharacteristicObj.addEventListener('characteristicvaluechanged',handleStreamDataOutNotifications);
            if(deviceOnGraphX != null){
                //console.log("feedTab3");
                intervID = setInterval(() => {
                    if(deviceOnGraphX == 1){
                        if(dataArray[0][1] == "1"){
                            // console.log("dataArray1[1][0]", dataArray[1][0]);
                            // console.log("dataArray1[0][0]", dataArray[0][0]);
                            // console.log("dataArray1[1][1]", dataArray[1][1]);
                            feedGraphDataSets(dataArray[1][0],dataArray[0][0],dataArray[1][1]);
                        }else{
                            // console.log("dataArray1[1][0]", dataArray[0][0]);
                            // console.log("dataArray1[0][0]", dataArray[1][0]);
                            // console.log("dataArray1[1][1]", dataArray[0][1]);
                            feedGraphDataSets(dataArray[0][0],dataArray[1][0],dataArray[0][1]);
    
                        }     
                    }else if(deviceOnGraphX == 0){
                        if(dataArray[0][1] == "0"){
                            // console.log("dataArray[1][0]", dataArray[1][0]);
                            // console.log("dataArray[0][0]", dataArray[0][0]);
                            // console.log("dataArray[1][1]", dataArray[1][1]);
                            feedGraphDataSets(dataArray[1][0],dataArray[0][0],dataArray[1][1]);
                        }else{
                            // console.log("dataArray1[1][0]", dataArray[0][0]);
                            // console.log("dataArray1[0][0]", dataArray[1][0]);
                            // console.log("dataArray1[1][1]", dataArray[0][1]);
                            feedGraphDataSets(dataArray[0][0],dataArray[1][0],dataArray[0][1]);
    
                        }   
                    }
                    if(MODE_ACQUISITION != "clavier"){
                        //console.log("feedTab");
                        feedTab();
                    }

                    
                }, sampleRateVal);

                
            }else{
                intervID = setInterval(() => {
    
                dataArray.forEach(element => {
                        // console.log(element);
                        if(element != null){
                            if(deviceOnGraph.includes(parseInt(element[1]))){
                                // if(deviceOnGraphX != null){
                                    // if(parseInt(element[1]) == deviceOnGraphX){
                                        
                                    // }
                                // }else{
                                    feedGraphDataSets(element[0], compt2, element[1])
                                    // console.log(element[0], compt2, element[1]); 
            
                                // }
                            }
                        }
                    });
                    if(MODE_ACQUISITION != "clavier"){
                        //console.log("feedTab");
                        feedTab();
                    }
            
                    if(document.getElementById("Tdef").checked){
                        if(compt2 >= parseInt(document.getElementById('timetdef').value)){
                            stop();
                        }
                    }
                    compt2 += sampleRateVal/1000
                
                }, sampleRateVal);
                
            // }
            }
            document.getElementById("play").style.display = "none";
            document.getElementById("pause").style.display = "block";   
        }else{
            for(let i = 0; i <= document.getElementsByClassName("lettrey").length-1; i++){
                document.getElementsByClassName("lettrey")[i].setAttribute("class", "animclign regroupement lettrey")
            }            
    
            window.alert("Veuillez mettre un appareil sur l'axe Y");
             
            
            
        }
    }else{
        window.alert("Veuillez connecter un appareil");
    }
    

}
function stop(){
    isstart = false;
    clearInterval(intervID);
    intervID = null;
    document.getElementById("pause").style.display = "none";
    document.getElementById("play").style.display = "block";
}
function playtest(){

    // for(let j = 0; j <= 50; j++){
        // setTimeout(() => {
        // if (star == false){
        //     star = true;    
        // }else{
        //     star = false;
        // }

            // startTimer = Date.now();
            setInterval(() => {
                for(let i = 0; i <= deviceOnGraph.length-1; i++){
                    if(deviceOnGraph[i] != null){
                        if(isstart){
                        // console.log("d")

                        feedGraphDataSets(getRandomInt(14), compt2, i);
                        compt2++;                  

                        }
                                           
                    } 
                }
                feedTab();

            }, sampleRateVal);
     
        // }, 10);

    // }


}
var compteurD = 0;
let tr = document.createElement("tr");
let tbody = document.createElement("tbody");
var compteurfeed = 0;
var devinceOnTab = [null,null];
function feedTab(val, uid){

    //console.log("start");
    let thx = document.createElement("th");
    let th0 = document.createElement("th");
    let th1 = document.createElement("th");
    let th22 = document.createElement("th");
    let th3 = document.createElement("th");
    // let tabtab = new Array();
    compteurfeed++;
    // // console.log(val)


        if((savedData[0].length-1 != -1)){
        // if((savedData[0].length-1 != -1) && (savedData[1].length-1 != -1)){
            thx.innerHTML = parseFloat(savedData[0][savedData[0].length-1].x);
            tr.setAttribute("class", "num");
            tr.appendChild(thx);     
            th0.innerHTML = savedData[0][savedData[0].length-1].y;
            tr.appendChild(th0);
        // }else if(element1 == 1){
            
            if(deviceOnGraph[1] != null && (savedData[1].length-1 != -1)){
                // console.log(savedData)
                th1.innerHTML = savedData[1][savedData[1].length-1].y
                tr.appendChild(th1);
            }

            tbody.appendChild(tr);
            tacontainer.appendChild(tbody)
            tr = document.createElement("tr");
            tbody = document.createElement("tbody");     
        }

}
// var tabgraph = new Array();
function exportgraphToCSV(){
    if(!isstart){
        if(savedData[0].length != 0 || savedData[1].length != 0){
            let tabgraph = new Array();
            let csv = " " + ",";
            let CSVname = window.prompt("Nom du fichier au format CSV", "graphique1");

            deviceOnGraph.forEach(element => {
                if(element != null){
                    let datasetIndex = deviceOnGraph.indexOf(element);
                    let dataset = config.data.datasets[datasetIndex];

                    if(dataset && dataset.label){
                        tabgraph.push(savedData[datasetIndex]);
                        if(CSVname != undefined){
                            csv += dataset.label + ",";
                            console.log(csv);
                        }
                    }
                }
            });

            csv += "\n";
            csv += "x" + ",";
            deviceOnGraph.forEach(element => {
                if(element != null){
                    csv += "y" + ",";
                }
            });
            csv += "\n";

            let tabcomine = [];
            for(let i = 0; i <= tabgraph[0].length - 1; i++){
                const soustab = [];
                soustab.push(parseFloat(tabgraph[0][i].x).toFixed(2));
                for(let j = 0; j < tabgraph.length; j++){
                    if(tabgraph[j][i].y != null){
                        soustab.push(parseFloat(tabgraph[j][i].y).toFixed(2));
                    }
                }
                tabcomine.push(soustab);
            }

            tabcomine.forEach(function(row) {
                csv += row.join(',');
                csv += "\n";
            });

            var hiddenElement = document.createElement('a');
            hiddenElement.href = 'data:text/csv;charset=utf-8,' + encodeURI(csv);
            hiddenElement.target = '_blank';
            hiddenElement.download = CSVname;
            hiddenElement.click();

        } else {
            window.alert("Aucune donnée dans le graphique");
        }
    } else {
        window.alert("Action impossible lors d'une acquisition !");
    }
}
inittab();
function resetDataGraph(){
    stop();
    if(!isstart){
        if(window.confirm("Voulez-vous vraiment supprimer les données du graphique?")){
            for(let i = 0; i < bluetoothDevice.length; i++){
                if(deviceOnGraphX != null){
                    if(deviceOnGraphX == i){
                        deviceOnGraphX = null;
                        config.options.scales.xAxes.title.text = 'Temps (en s)';
                        config.options.scales.xAxes.color = "";
                        try {
                            document.getElementById("l" + i).innerHTML = "";
                            document.getElementById("l" + i).style.backgroundColor = "#ffffff";
                          } catch (error) {
                            
                            // Expected output: ReferenceError: nonExistentFunction is not defined
                            // (Note: the exact output may be browser-dependent)
                          } 
                        
                        compteurDeviceOnGraph--;
                    }
                }
                for(let y = 0; y <= deviceOnGraph.length-1; y++){
                    
                    if(deviceOnGraph[y] != -1 && deviceOnGraph.includes(i)){
                        
                        if(deviceOnGraph[y] == i){
                            //console.log("i", i);
                            //console.log("y", y);
                            compteurDeviceOnGraph--;
                            try {
                                document.getElementById("l" + i).style.backgroundColor = "#ffffff";
                                document.getElementById("l" + i).innerHTML = "";
                              } catch (error) {
                                
                                // Expected output: ReferenceError: nonExistentFunction is not defined
                                // (Note: the exact output may be browser-dependent)
                              } 
                            
                            

                            switch (deviceOnGraph.indexOf(i)) {
                                case 0:
                                    config.options.scales.yAxes0.display = false;
                                    break;
                                case 1:
                                    config.options.scales.yAxes1.display = false;    

                                    break;
                                // case 2:
                                //     config.options.scales.yAxes2.display = false;     

                                //     break;
                                // case 3:
                                //     config.options.scales.yAxes3.display = false;     

                                //     break;
                            
                                default:

                                    break;
                            };

                            if(compteurDeviceOnGraph == 0){
                                document.getElementById("btnTab").style.display = "none"

                            }
                            document.getElementById("yax" +i).remove();
                            document.getElementById("header" +i).remove();

                            config.data.datasets.forEach(element2 => {
                                let idData = Number(element2.yAxisID.replace(/[^\d]/g, ""));
                                if(idData == deviceOnGraph[y]){
                                    config.data.datasets.splice(config.data.datasets.indexOf(element2),1);
                                    deviceOnGraph[y] = -1;
                                    //console.log(deviceOnGraph);
                                    return;
                                }

                            });
                            break;
                        }
                    }
                }
            }
            deviceOnGraph.forEach(element => {
                // console.log(deviceOnGraph.indexOf(element))
                
                    //console.log("ok1")
                    try {
                        config.data.datasets[0].data = [];
                      } catch (error) {
                        
                        // Expected output: ReferenceError: nonExistentFunction is not defined
                        // (Note: the exact output may be browser-dependent)
                      } 
                    
                    savedDatay0 = [];
                    savedDatay1 = [];
                    // savedDatay2 = [];
                    // savedDatay3 = [];
                    savedData = [savedDatay0, savedDatay1];
                    // savedData = [savedDatay0, savedDatay1, savedDatay2, savedDatay3];
                    passfirst = false;
                    compt2 = 0;
                    // myLine.destroy();
                    for(let i = document.getElementsByClassName("num").length-1; i >= 0; i--){
                        document.getElementsByClassName("num")[i].remove();
                    }
                    // tacontainer.childNodes.forEach(element => {
                    //     if(element.id == ""){
                    //         element.remove();
                    //     }
                    // });
                    
                    
                

            });
            reInitChart();
            if(deviceOnGraphX != null){
                setXaxis(deviceOnGraphX);
            }
            dataArray = [null, null];
        }
    }else{
        window.alert("Action impossible lors d'une acquisition !");
    }
}

function downsample(data, threshold) {
    // this function is from flot-downsample (MIT), with modifications

    var dataLength = data.length;
    if (threshold >= dataLength || threshold <= 0) {
        return data; // nothing to do
    }

    var sampled = [],
        sampledIndex = 0;

    // bucket size, leave room for start and end data points
    var every = (dataLength - 2) / (threshold - 2);

    var a = 0,  // initially a is the first point in the triangle
        maxAreaPoint,
        maxArea,
        area,
        nextA;

    // always add the first point
    sampled[sampledIndex++] = data[a];
    var floor = Math.floor;
    var abs = Math.abs;
    for (var i = 0; i < threshold - 2; i++) {
        // Calculate point average for next bucket (containing c)
        var avgX = 0,
            avgY = 0,
            avgRangeStart = floor(( i + 1 ) * every) + 1,
            avgRangeEnd = floor(( i + 2 ) * every) + 1;
        avgRangeEnd = avgRangeEnd < dataLength ? avgRangeEnd : dataLength;

        var avgRangeLength = avgRangeEnd - avgRangeStart;

        for (; avgRangeStart < avgRangeEnd; avgRangeStart++) {
            avgX += data[avgRangeStart].x * 1; // * 1 enforces Number (value may be Date)
            avgY += data[avgRangeStart].y * 1;
        }
        avgX /= avgRangeLength;
        avgY /= avgRangeLength;

        // Get the range for this bucket
        var rangeOffs = floor((i + 0) * every) + 1,
            rangeTo = floor((i + 1) * every) + 1;

        // Point a
        var pointAX = data[a].x * 1, // enforce Number (value may be Date)
        // var pointAX = (Date.now() - startTimer) /1000, // enforce Number (value may be Date)
            pointAY = data[a].y * 1;

        maxArea = area = -1;

        for (; rangeOffs < rangeTo; rangeOffs++) {
            // Calculate triangle area over three buckets
            area = abs(( pointAX - avgX ) * ( data[rangeOffs].y - pointAY ) -
                    ( pointAX - data[rangeOffs].x ) * ( avgY - pointAY )
                ) * 0.5;
            if (area > maxArea) {
                maxArea = area;
                maxAreaPoint = data[rangeOffs];
                nextA = rangeOffs; // Next a is this b
            }
        }

        sampled[sampledIndex++] = maxAreaPoint; // Pick this point from the bucket
        a = nextA; // This a is the next a (chosen b)
    }

    sampled[sampledIndex] = data[dataLength - 1]; // Always add last

    return sampled;
}
var savedDatay0 = [];
var savedDatay1 = [];
// var savedDatay2 = [];
// var savedDatay3 = [];
var savedData = [savedDatay0, savedDatay1];
// var savedData = [savedDatay0, savedDatay1, savedDatay2, savedDatay3];
var dataX = 0;
var dataY = 0;

function feedGraphDataSets(val, input,id){
    config.options.scales.xAxes.ticks.beginAtZero = true;

    // console.log(val, id)

        let uid = deviceOnGraph.indexOf(parseInt(id));
        // let uid = parseInt(id);
        savedData[uid].push({x:input,y:val});
        // feedTab(savedData[uid], uid);

        // let index = deviceOnGraph.indexOf(uid);
        config.data.datasets[uid].data = downsample( savedData[uid],samplingPointOnGraph);

        // dataY++;
        myLine.update();
}

/////////////////////////////////////// CHART CONF ///////////////////////////////////////////
// const labels = "graph";

var data = {
    // labels: labels,
    datasets: [
   ]
  };
  
  var config = {
    type: 'line',
    // data,
    // type: 'line',
    // options: {
    //   scales: {
    //     y: {
    //       beginAtZero: true
    //     }
    //   }
    // }
    options: {
        // line :{
        //     tension : "1.3",
        // },
        downsample: {
            enabled: true,
            threshold: samplingPointOnGraph, // max number of points to display per dataset
            onInit: true,
            auto: false,
            preferOriginalData: true, 
            restoreOriginalData: true,
        },
        // showLines : true,
        responsive: true,
        maintainAspectRatio: true,
        animation: false,
        hover: {animationDuration: 0},
        responsiveAnimationDuration: 0,
        elements:{
            point: {
                pointStyle: "cross",
                radius: 5,
                borderWidth: 2,
                hoverRadius: 5,
            },
        },
		scales: {
			yAxes0:
                {
                    id: "y-axis-0",
                    type: 'linear',
                    display: true,
                    position: "left",
                    title:{
                        text: "",
                        display: true,
                        color: borderColors[0],
                        // minRotation : 90
                    },
                    font: {
                        display: true, 
                    },

                },
            
			yAxes1:
                {
                    id: "y-axis-1",
                    type: 'linear',
                    display: false,
                    position: "right",
                    title:{
                        text: "",
                        display: true,
                        color: borderColors[1],
                    },
                    font: {
                        display: true, 
                    },
                },
            
			// yAxes2:
            //     {
            //         id: "y-axis-2",
            //         type: 'linear',
            //         display: false,
            //         position: "left",
            //         title:{
            //             text: "",
            //             display: true,
            //             color: borderColors[2],
            //         },
            //         font: {
            //             display: true, 
            //         },
            //     },
            
			// yAxes3:
            //     {
            //         id: "y-axis-3",
            //         type: 'linear',
            //         display: false,
            //         position: "right",
            //         title:{
            //             text: "",
            //             display: true,
            //             color: borderColors[3],
            //         },
            //         font: {
            //             display: true, 
            //         },
            //     },
            
            xAxes: {
                // gridLines: {color: "#2a2a2a"},
                type: 'linear',
                display: true,
                title: {display: true,text: "Temps (en s)"},
                ticks: {
                    stepSize: 3,
                    beginAtZero: false,
                    // fontColor: "#2a2a2a",
                },
            },
        },
        plugins:{
            zoom:{
                // pan:{
                //     enabled: true,
                //     mode: 'x',
                //     threshold: 10,
                // },
                zoom:{
                    drag:{
                        enabled: true,
                        // modifierKey: 'alt',
                        backgroundColor: "#2a2a2a",
                        threshold: 30,
                    },
                    wheel:{
                        enabled: false,
                    },
                    
                },

            },
        },
            //     zoom:{
            //         pan:{
            //             enabled: true,
            //             mode: 'xy',
            //             threshold: 1
            //         },

   
                // }
            // },

			
        
    } 
    
  };

function resetZoomGraph(){
   myLine.resetZoom(); 
}
var ctx = document.getElementById('graph').getContext('2d');
myLine = new Chart(ctx, config);

  function reInitChart(){
    firsttimepass = 0;
    myLine.destroy();
    myLine = new Chart(ctx, config);
}
var firsttimepass = 0;
var msfromgraph = 0
function setmsFromGraph(ms){
	msfromgraph += ms;	
}


var nmlabel = [
    "415 nm",
    "445 nm",
    "480 nm",
    "515 nm",
    "555 nm",
    "590 nm",
    "630 nm",
    "680 nm",
    "910 nm",
];


var datacolo = {
    labels: nmlabel,
    datasets: [
        {
            label: "Absorbance",
            data: [null, null,null, null,null, null,null, null,null],  
            borderColor: [
                "rgb(118,0,237)",
                "rgb(0,40,255)",
                "rgb(0,213,255)",
                "rgb(31,255,0)",
                "rgb(179,255,0)",
                "rgb(255,223,0)",
                "rgb(255,79,0)",
                "rgb(255,0,0)",
                "rgb(0,0,0)",                
            ],
            backgroundColor: [
                "rgba(118,0,237,0.3)",
                "rgba(0,40,255,0.3)",
                "rgba(0,213,255,0.3)",
                "rgba(31,255,0,0.3)",
                "rgba(179,255,0,0.3)",
                "rgba(255,223,0,0.3)",
                "rgba(255,79,0,0.3)",
                "rgba(255,0,0,0.3)",
                "rgba(0,0,0,0.3)",
                
            ],
            borderWidth: 1,
        },
    ],
  };
  
  var configcolo = {
    type: 'bar',
    data: datacolo,
    // type: 'line',
    // options: {
    //   scales: {
    //     y: {
    //       beginAtZero: true
    //     }
    //   }
    // }
    options: {
        // line :{
        //     tension : "1.3",
        // },
        // downsample: {
        //     enabled: true,
        //     threshold: samplingPointOnGraph, // max number of points to display per dataset
        //     onInit: true,
        //     auto: false,
        //     preferOriginalData: true, 
        //     restoreOriginalData: true,
        // },
        // showLines : true,
        responsive: true,
        maintainAspectRatio: false,
        animation: false,
        hover: {animationDuration: 0},
        responsiveAnimationDuration: 0,
        // elements:{
        //     point: {
        //         pointStyle: "cross",
        //         radius: 5,
        //         borderWidth: 2,
        //         hoverRadius: 5,
        //     },
        // },
		scales: {
            y:{
                min: 0,
                max: 3,
            },
        },
		// 	yAxes0:
        //         {
        //             id: "y-axis-0",
        //             type: 'linear',
        //             display: true,
        //             position: "left",
        //             min: 0,
        //             max: 3,
        //             title:{
        //                 text: "",
        //                 display: false,
        //                 // color: borderColors[0],
        //                 // minRotation : 90
        //             },
        //             font: {
        //                 display: true, 
        //             },

        //         },
            
		// 	// yAxes1:
        //     //     {
        //     //         id: "y-axis-1",
        //     //         type: 'linear',
        //     //         display: false,
        //     //         position: "right",
        //     //         title:{
        //     //             text: "",
        //     //             display: true,
        //     //             color: borderColors[1],
        //     //         },
        //     //         font: {
        //     //             display: true, 
        //     //         },
        //     //     },
        //     xAxes: {
        //         // gridLines: {color: "#2a2a2a"},
        //         type: 'linear',
        //         display: true,
        //         // title: {display: true,text: "Temps (en s)"},
        //         ticks: {
        //             stepSize: 1,
        //             beginAtZero: false,
        //             // fontColor: "#2a2a2a",
        //         },
        //     },
        // },
        plugins:{
            legend:{
                display: false,
            }
        },
        //     zoom:{
        //         // pan:{
        //         //     enabled: true,
        //         //     mode: 'x',
        //         //     threshold: 10,
        //         // },
        //         zoom:{
        //             drag:{
        //                 enabled: true,
        //                 // modifierKey: 'alt',
        //                 backgroundColor: "#2a2a2a",
        //                 threshold: 10,
        //             },
        //             wheel:{
        //                 enabled: true,
        //             },
                    
        //         },

        //     },
        // },
            //     zoom:{
            //         pan:{
            //             enabled: true,
            //             mode: 'xy',
            //             threshold: 1
            //         },

   
                // }
            // },

			
        
    } 
    
  };

// var coloctx = document.getElementById("graphcolo").getContext("2d");
// myLinecolo = new Chart(coloctx, configcolo);
window.addEventListener("orientationchange", function(event) {reInitChart();});
window.visualViewport.addEventListener("resize", function viewportHandler(event) {reInitChart();});