

var workspace; 
var checkboxChecked = 0;
var editor;
const term = new Terminal({
	cursorBlink: true,
	macOptionIsMeta: true,
	scrollback: true,
});
var userREPLInstalled = false;
const fit = new FitAddon.FitAddon();
var replCharacteristicObj = null;

term.loadAddon(fit);
term.loadAddon(new WebLinksAddon.WebLinksAddon());
term.loadAddon(new SearchAddon.SearchAddon());

term.open(document.getElementById("terminal"));
fit.fit();


function Initialization(){
	document.getElementById("dropdownVue").childNodes.forEach(element => {
		if(element.id != undefined){
			let checkboxContainer = element;
			checkboxContainer.childNodes.forEach(element2 => {
				if(element2.type == "checkbox"){
					if(element2.checked){
						checkboxChecked++;
					}
				}
			});
			
		}
	});editor = CodeMirror.fromTextArea(document.getElementById("code"), {
		mode: { name: "python", version: 3, singleLineStringErrors: false },
		lineNumbers: true,
		indentUnit: 4,
		matchBrackets: true,
		readOnly: false // Ajoutez cette ligne pour rendre l'éditeur en lecture seule
	});
	
	
		
	
	
		
	editor.setOption("theme", "ayu-dark");
	InitBlockly();
	ResizeView();
	InitGrosChiffre();
	initChartConf();
	Blockly.svgResize(workspace);
	
}
function InitBlockly(){
	workspace = Blockly.inject('blocklyDiv',{toolbox: document.getElementById('toolbox'),
				theme: 'dark',
				zoom:
					{controls: true,
					wheel: true,
					startScale: 1.0,
					maxScale: 3,
					minScale: 0.3,
					scaleSpeed: 1.2,
					pinch: true},
				trashcan: true
	});
	Blockly.svgResize(workspace);
}
Initialization();




const logoScthic = "data:image/svg+xml;base64,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"
const logoGomme = "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAzMiAzMiI+CiAgICA8cGF0aCBzdHlsZT0idGV4dC1pbmRlbnQ6MDt0ZXh0LWFsaWduOnN0YXJ0O2xpbmUtaGVpZ2h0Om5vcm1hbDt0ZXh0LXRyYW5zZm9ybTpub25lO2Jsb2NrLXByb2dyZXNzaW9uOnRiOy1pbmtzY2FwZS1mb250LXNwZWNpZmljYXRpb246Qml0c3RyZWFtIFZlcmEgU2FucyIgZD0iTSAxOC45MDYyNSA0LjA5Mzc1IEMgMTguMTAwNTUxIDQuMDkyNDcwNiAxNy4yNjc0MzYgNC4zNjY0NDU0IDE2LjYyNSA0LjkzNzUgTCAxNi42MjUgNC45Njg3NSBMIDE2LjU5Mzc1IDUgTCA0LjkwNjI1IDE2LjU5Mzc1IEMgMy42OTM3NzEgMTcuODA2MjI5IDMuNzAxNjQwOCAxOS43Nzc2MjcgNC44NDM3NSAyMS4wNjI1IEwgNC44NzUgMjEuMDkzNzUgTCA0LjkwNjI1IDIxLjA5Mzc1IEwgMTAuOTA2MjUgMjcuMDkzNzUgQyAxMi4xMTg3MjkgMjguMzA2MjI5IDE0LjA5MDEyNyAyOC4yOTgzNTkgMTUuMzc1IDI3LjE1NjI1IEwgMTUuMzc1IDI3LjEyNSBMIDE1LjQwNjI1IDI3LjA5Mzc1IEwgMjcgMTUuNSBDIDI4LjI2NjY0OCAxNC4yMzMzNTIgMjguMzA2MjI5IDEyLjIxMjQ3OSAyNy4wOTM3NSAxMSBMIDIxLjA5Mzc1IDUgQyAyMC40ODc1MTEgNC4zOTM3NjA1IDE5LjcxMTk0OSA0LjA5NTAyOTQgMTguOTA2MjUgNC4wOTM3NSB6IE0gMTguODc1IDYuMTI1IEMgMTkuMTk0MzAxIDYuMTIzNzIgMTkuNDkzNzM5IDYuMjEyNDkgMTkuNjg3NSA2LjQwNjI1IEwgMjUuNjg3NSAxMi40MDYyNSBDIDI2LjA3NTAyMSAxMi43OTM3NzEgMjYuMTI3MTAyIDEzLjU2MDM5OCAyNS41OTM3NSAxNC4wOTM3NSBMIDIwLjU2MjUgMTkuMTI1IEwgMTIuOTA2MjUgMTEuNDY4NzUgTCAxNy45Njg3NSA2LjQzNzUgTCAxOCA2LjQwNjI1IEMgMTguMjUyOTA3IDYuMTk2NDU5MSAxOC41Njg5MzIgNi4xMjYyMjY0IDE4Ljg3NSA2LjEyNSB6IE0gMTEuNDY4NzUgMTIuOTA2MjUgTCAxOS4xMjUgMjAuNTYyNSBMIDE0LjAzMTI1IDI1LjY1NjI1IEMgMTQuMDIwNTQgMjUuNjY1NzUgMTQuMDEwOTcgMjUuNjc4NCAxNCAyNS42ODc1IEMgMTMuNDgzMjQ3IDI2LjExNjA1OSAxMi42OTE5NjQgMjYuMDY2OTY0IDEyLjMxMjUgMjUuNjg3NSBMIDYuMzQzNzUgMTkuNzUgQyA2LjMyNzgyOTIgMTkuNzMyMDg5IDYuMzI3MjQ2NCAxOS43MDYxMzEgNi4zMTI1IDE5LjY4NzUgQyA1LjkwMzEzMDMgMTkuMTcwMyA1LjkzODQ1MyAxOC4zNzQwNDcgNi4zMTI1IDE4IEwgMTEuNDY4NzUgMTIuOTA2MjUgeiIgY29sb3I9IiMwMDAiIG92ZXJmbG93PSJ2aXNpYmxlIiBmb250LWZhbWlseT0iQml0c3RyZWFtIFZlcmEgU2FucyIvPgo8L3N2Zz4=";
const logoimg = "data:image/svg+xml;base64,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";
const crossimg = "data:image/svg+xml;base64,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";
const csvimg = "data:image/svg+xml;base64,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"
const imgPowerSymbBlack = "data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iaXNvLTg4NTktMSI/Pg0KPCEtLSBHZW5lcmF0b3I6IEFkb2JlIElsbHVzdHJhdG9yIDE4LjEuMSwgU1ZHIEV4cG9ydCBQbHVnLUluIC4gU1ZHIFZlcnNpb246IDYuMDAgQnVpbGQgMCkgIC0tPg0KPHN2ZyB2ZXJzaW9uPSIxLjEiIGlkPSJDYXBhXzEiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgeG1sbnM6eGxpbms9Imh0dHA6Ly93d3cudzMub3JnLzE5OTkveGxpbmsiIHg9IjBweCIgeT0iMHB4Ig0KCSB2aWV3Qm94PSIwIDAgMzAuMTQzIDMwLjE0MyIgc3R5bGU9ImVuYWJsZS1iYWNrZ3JvdW5kOm5ldyAwIDAgMzAuMTQzIDMwLjE0MzsiIHhtbDpzcGFjZT0icHJlc2VydmUiPg0KPGc+DQoJPHBhdGggc3R5bGU9ImZpbGw6IzAzMDEwNDsiIGQ9Ik0yMC4wMzQsMi4zNTd2My44MjRjMy40ODIsMS43OTgsNS44NjksNS40MjcsNS44NjksOS42MTljMCw1Ljk4LTQuODQ4LDEwLjgzLTEwLjgyOCwxMC44Mw0KCQljLTUuOTgyLDAtMTAuODMyLTQuODUtMTAuODMyLTEwLjgzYzAtMy44NDQsMi4wMTItNy4yMTUsNS4wMjktOS4xMzZWMi42ODlDNC4yNDUsNC45MTgsMC43MzEsOS45NDUsMC43MzEsMTUuODAxDQoJCWMwLDcuOTIxLDYuNDIsMTQuMzQyLDE0LjM0LDE0LjM0MmM3LjkyNCwwLDE0LjM0Mi02LjQyMSwxNC4zNDItMTQuMzQyQzI5LjQxMiw5LjYyNCwyNS41MDEsNC4zNzksMjAuMDM0LDIuMzU3eiIvPg0KCTxwYXRoIHN0eWxlPSJmaWxsOiMwMzAxMDQ7IiBkPSJNMTQuNzk1LDE3LjY1MmMxLjU3NiwwLDEuNzM2LTAuOTMxLDEuNzM2LTIuMDc2VjIuMDhjMC0xLjE0OC0wLjE2LTIuMDgtMS43MzYtMi4wOA0KCQljLTEuNTcsMC0xLjczMiwwLjkzMi0xLjczMiwyLjA4djEzLjQ5NkMxMy4wNjIsMTYuNzIyLDEzLjIyNSwxNy42NTIsMTQuNzk1LDE3LjY1MnoiLz4NCjwvZz4NCjxnPg0KPC9nPg0KPGc+DQo8L2c+DQo8Zz4NCjwvZz4NCjxnPg0KPC9nPg0KPGc+DQo8L2c+DQo8Zz4NCjwvZz4NCjxnPg0KPC9nPg0KPGc+DQo8L2c+DQo8Zz4NCjwvZz4NCjxnPg0KPC9nPg0KPGc+DQo8L2c+DQo8Zz4NCjwvZz4NCjxnPg0KPC9nPg0KPGc+DQo8L2c+DQo8Zz4NCjwvZz4NCjwvc3ZnPg0K"


// document.getElementById('coBtn').src = imgPowerSymbBlack;
document.getElementById('coBtn').src = "ressource/svg/001-usb.svg";
document.getElementById('pointToDelete').src = "ressource/svg/005-la-gomme.svg";
// document.getElementById('deleteLastdata').src = logoGomme;
document.getElementById('logo').src = logoimg;
document.getElementById('exportcsv').src = csvimg;
document.getElementById('sclogo').src = logoScthic;
document.getElementById('setLine').src = "ressource/svg/007-graphique-a-nuage-de-points.svg";

var stateconnected = false;

function changeView(){
	document.getElementById('dropdownVue').childNodes.forEach(element => {
		if(element.id != undefined){
			let checkboxContainer = element;
			checkboxContainer.childNodes.forEach(element2 => {
				if(element2.type == "checkbox"){
					
					if(element2.checked){
						document.getElementById(element2.name).style.display = "block";
						// console.log(element2.name)
					}else{
						if(element2.name != "Blockly"){
							InitBlockly();
							Blockly.svgResize(workspace);
							
						}
						document.getElementById(element2.name).style.display = "none";
					}	
				}
			});
			
		}
	});
}


function ImportLibAfficheur(){
	var cmd ="";
	cmd += "import os" + "\r\n"
	cmd += "try:" + "\r\n"
	cmd += "    f = open('lib/afficheurWEBAPP.py', 'x')" + "\r\n"
	cmd += "    f.close()" + "\r\n"
	cmd += "    f = open('lib/afficheurWEBAPP.py', 'w')" + "\r\n"
	cmd += "    f.write('\\n'+ \"import json\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"from ppy import millis\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"from sys import stdout\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"class afficheursWEBAPP(object):\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"  def __init__(self):\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"    self.REFRESH_RATE_MS = 50\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"    self.previousMessageTimestampMsGrosChiffre = 0\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"    self.identifierCounter = 0\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"    self.identifierList = {}\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"  def envoyer(self,valeur,inputValue=None,unit=None,identifier=None,inputUnit=None,refreshAnyway=False):\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"    now = millis()\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"    if ( now - self.previousMessageTimestampMsGrosChiffre ) >= self.REFRESH_RATE_MS :\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"      self.previousMessageTimestampMsGrosChiffre = now\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"      querySrc = json.dumps([\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"        str(identifier),\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"        str(valeur),\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"        str(unit),\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"        str(inputValue),\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"        str(inputUnit)\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"      ])\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"      querySerialized = json.dumps(querySrc)\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"      querySerialized = str(len(querySerialized)) + querySerialized\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"      print(\'\\\\n\')\")" + "\r\n"
	cmd += "    f.write('\\n'+ \"      stdout.write(querySerialized)\")" + "\r\n"
	cmd += "    f.close()" + "\r\n"
	cmd += "except:  print(\"lib already exist\")" + "\r\n"
	if ( !ppy.isInRAWReplMode() )
		ppy.enterRawRepl().then( _ =>{		
			return ppy.exec(cmd);	
		});	
	else
		 return ppy.exec(cmd);	
}

function ImportLibTone(){
	var code ="";
	code += "import os" + "\r\n"
	code += "try:" + "\r\n";
	code += "	f = open('lib/tone.py', 'x')" + "\r\n";
	code += " 	f.close()" + "\r\n";
	code += " 	f = open('lib/tone.py', 'w')" + "\r\n";
	code += "	f.write('\\nfrom ppy import Timer,Pin,delay')" + "\r\n";
	code += "	f.write('\\n_toneAvailablePin = {')" + "\r\n";
	code += "	f.write('\\n\"A1\":[2,1],\"D0\":[3,2],\"D1\":[3,1],\"D3\":[2,1],\"D4\":[3,2],\"D6\":[2,2],\"D8\":[3,4],\"D10\":[1,3],\"D11\":[1,2],\"D13\":[1,1],}\\n')" + "\r\n";
	code += "	f.write(\"\\nNOTES = {\\n'B1': 62,\\n'B0': 31,\\n'GS4': 415,\\n'B4': 494, \\n'GS5': 831, \\n'B5': 988, \\n'GS6': 1661, \\n'B6': 1976, \\n'C7': 2093, \\n'D7': 2349, \\n'E7': 2637, \\n'F7': 2794, \\n'GS7': 3322, \\n'AS7': 3729, \\n'A4': 440, \\n'A5': 880, \\n'A6': 1760, \\n'A7': 3520, \\n'B7': 3951, \\n'A1': 55, \\n'A2': 110, \\n'A3': 220, \\n'C8': 4186, \\n'D8': 4699, \\n'CS5': 554, \\n'CS4': 277, \\n'CS7': 2217, \\n'CS6': 1109, \\n'CS1': 35, \\n'DS8': 4978, \\n'CS3': 139, \\n'CS2': 69, \\n'REST': 0, \\n'FS1': 46, \\n'FS2': 93, \\n'FS3': 185, \\n'FS4': 370, \\n'FS5': 740, \\n'FS6': 1480, \\n'FS7': 2960, \\n'G2': 98, \\n'G3': 196, \\n'CS8': 4435, \\n'G1': 49, \\n'G6': 1568, \\n'G7': 3136, \\n'F3': 175, \\n'F2': 87, \\n'F1': 44, \\n'DS2': 78, \\n'DS3': 156, \\n'DS1': 39, \\n'G4': 392, \\n'F4': 349, \\n'DS4': 311, \\n'AS4': 466, \\n'AS3': 233, \\n'AS2': 117, \\n'AS1': 58, \\n'DS5': 622, \\n'F5': 698, \\n'G5': 784, \\n'AS5': 932, \\n'DS6': 1245, \\n'F6': 1397, \\n'AS6': 1865, \\n'DS7': 2489, \\n'E1': 41, \\n'E2': 82, \\n'E3': 165, \\n'E4': 330, \\n'E5': 659, \\n'D1': 37, \\n'E6': 1319, \\n'D3': 147, \\n'D2': 73, \\n'D5': 587, \\n'D4': 294, \\n'C6': 1047, \\n'D6': 1175, \\n'C4': 262, \\n'C5': 523, \\n'GS1': 52, \\n'C2': 65, \\n'C3': 131, \\n'C1': 33, \\n'GS2': 104, \\n'GS3': 208, \\n'B3': 247, \\n'B2': 123}\")" + "\r\n";	
	code += "	f.write('\\ndef tone(pin,frequency,durationMs=None,intensity=None):')" + "\r\n";
	code += "	f.write('\\n  if pin not in _toneAvailablePin :')" + "\r\n";
	code += "	f.write('\\n    raise ValueError(\"pin param. (provided : \"+str(pin)+\") must be one of : A1/D0/D1/D3/D4/D6/D8/D10/D11/D13.\")')" + "\r\n";
	code += "	f.write('\\n  if not(isinstance(intensity,int)) : intensity = 10')" + "\r\n";
	code += "	f.write('\\n  elif intensity > 50 : intensity = 50')" + "\r\n";
	code += "	f.write('\\n  if frequency == 0 :')" + "\r\n";
	code += "	f.write('\\n    Timer(_toneAvailablePin[pin][0])')" + "\r\n";
	code += "	f.write('\\n    return')" + "\r\n";
	code += "	f.write('\\n  timInstance = Timer(_toneAvailablePin[pin][0],freq=frequency)')" + "\r\n";
	code += "	f.write('\\n  timInstance.channel(_toneAvailablePin[pin][1],Timer.PWM,pin=Pin(pin),pulse_width_percent=intensity)')" + "\r\n";
	code += "	f.write('\\n  if isinstance(durationMs,int) :')" + "\r\n";
	code += "	f.write('\\n    delay(durationMs)')" + "\r\n";
	code += "	f.write('\\n    timInstance.deinit()')" + "\r\n";
	code += "	f.close()" + "\r\n";
	code += "except:  print(\"lib already exist\")" + "\r\n";
	if ( !ppy.isInRAWReplMode() )
		ppy.enterRawRepl().then( _ =>{		
			return ppy.exec(code);	
		});	
	else
		 return ppy.exec(code);	
}
function ImportLibI2C(){
	var code ="";
	code += "try:" + "\r\n";
	code += "	f = open('lib/I2CRelayController.py', 'x')" + "\r\n";
	code += "	f.close()" + "\r\n";
	code += "	f = open('lib/I2CRelayController.py', 'w')" + "\r\n";
	code += "	f.write('\\n# Begin I2C Relay Controller Driver')" + "\r\n";
	code += "	f.write('\\n# Work with :')" + "\r\n";
	code += "	f.write('\\n# - Sciencethic 651 071 4-Channel Relay Controller')" + "\r\n";
	code += "	f.write('\\n# - Grove 4-Channel SPDT Relay (103020133)')" + "\r\n";
	code += "	f.write('\\nfrom ppy import I2C')" + "\r\n";
	code += "	f.write('\\nfrom ppy import delay')" + "\r\n";
	code += "	f.write('\\nclass RelayController(object):')" + "\r\n";
	code += "	f.write('\\n	i2cBus = I2C()')" + "\r\n";
	code += "	f.write('\\n	')" + "\r\n";
	code += "	f.write('\\n	DEFAULT_IIC_ADDR = 0x11')" + "\r\n";
	code += "	f.write('\\n	CMD_READ_FIRMWARE_VER = 0x13')" + "\r\n";
	code += "	f.write('\\n	CMD_CHANNEL_CTRL = 0x10')" + "\r\n";
	code += "	f.write('\\n	CMD_SAVE_I2C_ADDR = 0x11')" + "\r\n";
	code += "	f.write('\\n	FW_VER = 0x01')" + "\r\n";
	code += "	f.write('\\n	def __init__(self,addr=DEFAULT_IIC_ADDR):')" + "\r\n";
	code += "	f.write('\\n	')" + "\r\n";
	code += "	f.write('\\n		if self.i2cBus.is_ready(addr) is not True :')" + "\r\n";
	code += "	f.write('\\n			raise Exception(\"\\\\n\\\\nI2C : device not responding.\\\\nTry RelayController.FIND() to detect the user-definied IIC address.\\\\nSpecify an user-definied address by adding addr=<<your device address>> param to RelayController object constructor.\\\\n\")')" + "\r\n";
	code += "	f.write('\\n	')" + "\r\n";
	code += "	f.write('\\n		self._i2cAddr = addr')" + "\r\n";
	code += "	f.write('\\n		self.channel_state = 0x00')" + "\r\n";
	code += "	f.write('\\n		')" + "\r\n";
	code += "	f.write('\\n	def changeI2CAddress(self,new_addr):')" + "\r\n";
	code += "	f.write('\\n		self.i2cBus.send(bytearray([self.CMD_SAVE_I2C_ADDR,new_addr]),addr=self._i2cAddr)')" + "\r\n";
	code += "	f.write('\\n		self._i2cAddr = new_addr')" + "\r\n";
	code += "	f.write('\\n		delay(20)')" + "\r\n";
	code += "	f.write('\\n		')" + "\r\n";
	code += "	f.write('\\n	def getChannelState(self):')" + "\r\n";
	code += "	f.write('\\n		return self.channel_state')" + "\r\n";
	code += "	f.write('\\n		')" + "\r\n";
	code += "	f.write('\\n	def getFirmwareVersion(self):')" + "\r\n";
	code += "	f.write('\\n		self.i2cBus.send(self.CMD_READ_FIRMWARE_VER,addr=self._i2cAddr)')" + "\r\n";
	code += "	f.write('\\n		addr = self.i2cBus.recv(1,addr=self._i2cAddr);')" + "\r\n";
	code += "	f.write('\\n		delay(20)')" + "\r\n";
	code += "	f.write('\\n		return addr')" + "\r\n";
	code += "	f.write('\\n		')" + "\r\n";
	code += "	f.write('\\n	def channelCtrl(self,state):')" + "\r\n";
	code += "	f.write('\\n		self.channel_state = state;')" + "\r\n";
	code += "	f.write('\\n		self.i2cBus.send(bytearray([self.CMD_CHANNEL_CTRL,self.channel_state]),addr=self._i2cAddr)')" + "\r\n";
	code += "	f.write('\\n		delay(20)')" + "\r\n";
	code += "	f.write('\\n		')" + "\r\n";
	code += "	f.write('\\n	def turn_on_channel(self,channel):')" + "\r\n";
	code += "	f.write('\\n		if channel < 1 or channel > 8 :')" + "\r\n";
	code += "	f.write('\\n			raise Exception(\\'Invalid channel number. Valid 1,2,3,4(5,6,7,8)\\')')" + "\r\n";
	code += "	f.write('\\n		self.channel_state |= (1 << (channel - 1))')" + "\r\n";
	code += "	f.write('\\n		self.channelCtrl(self.channel_state)')" + "\r\n";
	code += "	f.write('\\n		delay(20)')" + "\r\n";
	code += "	f.write('\\n		')" + "\r\n";
	code += "	f.write('\\n	def turn_off_channel(self,channel):')" + "\r\n";
	code += "	f.write('\\n		if channel < 1 or channel > 8 :')" + "\r\n";
	code += "	f.write('\\n			raise Exception(\\'Invalid channel number. Valid 1,2,3,4(5,6,7,8)\\')')" + "\r\n";
	code += "	f.write('\\n		self.channel_state &= ~(1 << (channel - 1))')" + "\r\n";
	code += "	f.write('\\n		self.channelCtrl(self.channel_state)')" + "\r\n";
	code += "	f.write('\\n		delay(20)')" + "\r\n";
	code += "	f.write('\\n		')" + "\r\n";
	code += "	f.write('\\n	# Static method. Try to find the relay controller address on the IIC bus.')" + "\r\n";
	code += "	f.write('\\n	# Might be useful as the device IIC address can be change by the end user.')" + "\r\n";
	code += "	f.write('\\n	# Return -1 if not found.')" + "\r\n";
	code += "	f.write('\\n	def FIND():')" + "\r\n";
	code += "	f.write('\\n		res = RelayController.i2cBus.scan()')" + "\r\n";
	code += "	f.write('\\n		found = False')" + "\r\n";
	code += "	f.write('\\n		if len(res) is 0 :')" + "\r\n";
	code += "	f.write('\\n			print(\"No IIC device found.\")')" + "\r\n";
	code += "	f.write('\\n		else :')" + "\r\n";
	code += "	f.write('\\n			for addr in res :')" + "\r\n";
	code += "	f.write('\\n				RelayController.i2cBus.send(RelayController.CMD_READ_FIRMWARE_VER,addr=addr)')" + "\r\n";
	code += "	f.write('\\n				fwVer = RelayController.i2cBus.recv(1,addr=addr)')" + "\r\n";
	code += "	f.write('\\n				delay(20)')" + "\r\n";
	code += "	f.write('\\n				if int.from_bytes(fwVer,\\'big\\') is RelayController.FW_VER :')" + "\r\n";
	code += "	f.write('\\n					strHexAddr = \"0x\".join(\"{:02x}\".format(c) for c in res)')" + "\r\n";
	code += "	f.write('\\n					print(\"\\\\nRelay controller found. Address is : 0x\"+strHexAddr+\".\\\\nAdd param address in RelayController constructor to override the default address :\\\\n-> RelayController(addr=0x\"+strHexAddr+\")\\\\n\")')" + "\r\n";
	code += "	f.write('\\n					found = True')" + "\r\n";
	code += "	f.write('\\n			if found is False :')" + "\r\n";
	code += "	f.write('\\n				print(len(res),\"IIC device found. Relay controller not detected...\")')" + "\r\n";
	code += "	f.write('\\n				')" + "\r\n";
	code += "	f.write('\\n# End I2C Relay Controller Driver')" + "\r\n";
	code += "	f.close()" + "\r\n";
	code += "except:	print('lib already exist')" + "\r\n";
	if ( !ppy.isInRAWReplMode() )
		ppy.enterRawRepl().then( _ =>{		
			return ppy.exec(code);	
		});	
	else
		 return ppy.exec(code);	
}
function ImportLibLCD(){
	var code ="";
	code += "try:" + "\r\n";
	code += "	f = open('lib/LCD16x2RGB.py', 'x')" + "\r\n";
	code += "	f.close()" + "\r\n";
	code += "	f = open('lib/LCD16x2RGB.py', 'w')" + "\r\n";
	code += "	f.write('\\n# Begin I2C LCD 16x2 RGB Driver')" + "\r\n";
	code += "	f.write('\\n# Work with :')" + "\r\n";
	code += "	f.write('\\n# Grove - LCD RGB Backlight')" + "\r\n";
	code += "	f.write('\\n# AKA Sciencethic 651 018')" + "\r\n";
	code += "	f.write('\\nfrom ppy import I2C')" + "\r\n";
	code += "	f.write('\\nfrom ppy import delay,udelay')" + "\r\n";
	code += "	f.write('\\nclass LCD16x2RGB(object):')" + "\r\n";
	code += "	f.write('\\n	i2cBus = I2C()')" + "\r\n";
	code += "	f.write('\\n	# BackLight Adr & Reg')" + "\r\n";
	code += "	f.write('\\n	BL_ADDR         = 0x62')" + "\r\n";
	code += "	f.write('\\n	BL_MD1_REG      = 0x00')" + "\r\n";
	code += "	f.write('\\n	BL_MD2_REG      = 0x01')" + "\r\n";
	code += "	f.write('\\n	BL_BLUE_REG     = 0x02')" + "\r\n";
	code += "	f.write('\\n	BL_GREEN_REG    = 0x03')" + "\r\n";
	code += "	f.write('\\n	BL_RED_REG      = 0x04')" + "\r\n";
	code += "	f.write('\\n	BL_OUT_REG      = 0x08')" + "\r\n";
	code += "	f.write('\\n	# LCD Adr & Reg')" + "\r\n";
	code += "	f.write('\\n	LCD_ADDR = 0x3E')" + "\r\n";
	code += "	f.write('\\n	LCD_CLEARDISPLAY = 0x01')" + "\r\n";
	code += "	f.write('\\n	LCD_RETURNHOME = 0x02')" + "\r\n";
	code += "	f.write('\\n	LCD_ENTRYMODESET = 0x04')" + "\r\n";
	code += "	f.write('\\n	LCD_DISPLAYCONTROL = 0x08')" + "\r\n";
	code += "	f.write('\\n	LCD_FUNCTIONSET = 0x20')" + "\r\n";
	code += "	f.write('\\n	LCD_ENTRYLEFT = 0x02')" + "\r\n";
	code += "	f.write('\\n	LCD_ENTRYSHIFTINCREMENT = 0x01')" + "\r\n";
	code += "	f.write('\\n	LCD_ENTRYSHIFTDECREMENT = 0x00')" + "\r\n";
	code += "	f.write('\\n	LCD_DISPLAYON = 0x04')" + "\r\n";
	code += "	f.write('\\n	LCD_CURSORON = 0x02')" + "\r\n";
	code += "	f.write('\\n	LCD_CURSOROFF = 0x00')" + "\r\n";
	code += "	f.write('\\n	LCD_BLINKON = 0x01')" + "\r\n";
	code += "	f.write('\\n	LCD_BLINKOFF = 0x00')" + "\r\n";
	code += "	f.write('\\n	LCD_2LINE = 0x08')" + "\r\n";
	code += "	f.write('\\n	def __init__(self):')" + "\r\n";
	code += "	f.write('\\n		if self.i2cBus.is_ready(self.LCD_ADDR) is not True :')" + "\r\n";
	code += "	f.write('\\n			raise Exception(\\'I2C : device not responding\\')')" + "\r\n";
	code += "	f.write('\\n		# LCD Init')" + "\r\n";
	code += "	f.write('\\n		self.disp_func = self.LCD_DISPLAYON | self.LCD_2LINE')" + "\r\n";
	code += "	f.write('\\n		delay(50)')" + "\r\n";
	code += "	f.write('\\n		self.writeReg(self.LCD_ADDR,0x80,self.LCD_FUNCTIONSET | self.disp_func)')" + "\r\n";
	code += "	f.write('\\n		udelay(4500)')" + "\r\n";
	code += "	f.write('\\n		self.writeReg(self.LCD_ADDR,0x80,self.LCD_FUNCTIONSET | self.disp_func)')" + "\r\n";
	code += "	f.write('\\n		udelay(150)')" + "\r\n";
	code += "	f.write('\\n		self.writeReg(self.LCD_ADDR,0x80,self.LCD_FUNCTIONSET | self.disp_func)')" + "\r\n";
	code += "	f.write('\\n		self.disp_ctrl = self.LCD_DISPLAYON | self.LCD_CURSOROFF | self.LCD_BLINKOFF')" + "\r\n";
	code += "	f.write('\\n		self.display(True)')" + "\r\n";
	code += "	f.write('\\n		self.clear()')" + "\r\n";
	code += "	f.write('\\n		self.disp_mode = self.LCD_ENTRYLEFT | self.LCD_ENTRYSHIFTDECREMENT')" + "\r\n";
	code += "	f.write('\\n		self.writeReg(self.LCD_ADDR,0x80,self.LCD_ENTRYMODESET | self.disp_mode)')" + "\r\n";
	code += "	f.write('\\n		# BackLight Init')" + "\r\n";
	code += "	f.write('\\n		self.writeReg(self.BL_ADDR,self.BL_MD1_REG,0x00)')" + "\r\n";
	code += "	f.write('\\n		self.writeReg(self.BL_ADDR,self.BL_MD2_REG,0x00)')" + "\r\n";
	code += "	f.write('\\n		self.writeReg(self.BL_ADDR,self.BL_OUT_REG,0xAA)')" + "\r\n";
	code += "	f.write('\\n	def writeReg(self,devAdr,regAdr,val):')" + "\r\n";
	code += "	f.write('\\n		dta = bytearray([regAdr,val])')" + "\r\n";
	code += "	f.write('\\n		self.i2cBus.send(dta,addr=devAdr)')" + "\r\n";
	code += "	f.write('\\n	def write_char(self, c):')" + "\r\n";
	code += "	f.write('\\n		assert c >= 0 and c < 256')" + "\r\n";
	code += "	f.write('\\n		c = bytearray([int(c)])')" + "\r\n";
	code += "	f.write('\\n		self.i2cBus.mem_write(c,self.LCD_ADDR, 0x40)')" + "\r\n";
	code += "	f.write('\\n	def print(self, text):')" + "\r\n";
	code += "	f.write('\\n		for char in text:')" + "\r\n";
	code += "	f.write('\\n			self.write_char(ord(char))')" + "\r\n";
	code += "	f.write('\\n	def cursor(self, state):')" + "\r\n";
	code += "	f.write('\\n		if state:')" + "\r\n";
	code += "	f.write('\\n			self.disp_ctrl |= self.LCD_CURSORON')" + "\r\n";
	code += "	f.write('\\n			self.writeReg(self.LCD_ADDR,0x80,self.LCD_DISPLAYCONTROL  | self.disp_ctrl)')" + "\r\n";
	code += "	f.write('\\n		else:')" + "\r\n";
	code += "	f.write('\\n			self.disp_ctrl &= ~self.LCD_CURSORON')" + "\r\n";
	code += "	f.write('\\n			self.writeReg(self.LCD_ADDR,0x80,self.LCD_DISPLAYCONTROL  | self.disp_ctrl)')" + "\r\n";
	code += "	f.write('\\n	def setCursor(self, col, row):')" + "\r\n";
	code += "	f.write('\\n		col = (col | 0x80) if row == 0 else (col | 0xc0)')" + "\r\n";
	code += "	f.write('\\n		self.writeReg(self.LCD_ADDR,0x80,col)')" + "\r\n";
	code += "	f.write('\\n	def blink(self, state):')" + "\r\n";
	code += "	f.write('\\n		if state:')" + "\r\n";
	code += "	f.write('\\n			self.disp_ctrl |= self.LCD_BLINKON')" + "\r\n";
	code += "	f.write('\\n			self.writeReg(self.LCD_ADDR,0x80,self.LCD_DISPLAYCONTROL  | self.disp_ctrl)')" + "\r\n";
	code += "	f.write('\\n		else:')" + "\r\n";
	code += "	f.write('\\n			self.disp_ctrl &= ~self.LCD_BLINKON')" + "\r\n";
	code += "	f.write('\\n			self.writeReg(self.LCD_ADDR,0x80,self.LCD_DISPLAYCONTROL  | self.disp_ctrl)')" + "\r\n";
	code += "	f.write('\\n	def display(self, state):')" + "\r\n";
	code += "	f.write('\\n		if state:')" + "\r\n";
	code += "	f.write('\\n			self.disp_ctrl |= self.LCD_DISPLAYON')" + "\r\n";
	code += "	f.write('\\n			self.writeReg(self.LCD_ADDR,0x80,self.LCD_DISPLAYCONTROL  | self.disp_ctrl)')" + "\r\n";
	code += "	f.write('\\n		else:')" + "\r\n";
	code += "	f.write('\\n			self.disp_ctrl &= ~self.LCD_DISPLAYON')" + "\r\n";
	code += "	f.write('\\n			self.writeReg(self.LCD_ADDR,0x80,self.LCD_DISPLAYCONTROL  | self.disp_ctrl)')" + "\r\n";
	code += "	f.write('\\n	def clear(self):')" + "\r\n";
	code += "	f.write('\\n		self.writeReg(self.LCD_ADDR,0x80,self.LCD_CLEARDISPLAY)')" + "\r\n";
	code += "	f.write('\\n		delay(2)')" + "\r\n";
	code += "	f.write('\\n	def home(self):')" + "\r\n";
	code += "	f.write('\\n		self.writeReg(self.LCD_ADDR,0x80,self.LCD_RETURNHOME)')" + "\r\n";
	code += "	f.write('\\n		delay(2)')" + "\r\n";
	code += "	f.write('\\n	def setColor(self,r,g,b):')" + "\r\n";
	code += "	f.write('\\n		self.writeReg(self.BL_ADDR,self.BL_RED_REG,r)')" + "\r\n";
	code += "	f.write('\\n		self.writeReg(self.BL_ADDR,self.BL_GREEN_REG,g)')" + "\r\n";
	code += "	f.write('\\n		self.writeReg(self.BL_ADDR,self.BL_BLUE_REG,b)')" + "\r\n";
	code += "	f.write('\\n		# End I2C LCD 16x2 RGB Driver')" + "\r\n";
	code += "	f.close()" + "\r\n";
	code += "except:	print('lib already exist')" + "\r\n";
	if ( !ppy.isInRAWReplMode() )
		ppy.enterRawRepl().then( _ =>{		
			return ppy.exec(code);	
		});	
	else
		 return ppy.exec(code);	
}
function ImportLibRanger(){
	var code ="";
	code += "try:" + "\r\n";
	code += "	f = open('lib/USRanger.py', 'x')" + "\r\n";
	code += "	f.close()" + "\r\n";
	code += "	f = open('lib/USRanger.py', 'w')" + "\r\n";
	code += "	f.write('\\n# Begin Ultrasonic Ranger Driver')" + "\r\n";
	code += "	f.write('\\n# Work with :')" + "\r\n";
	code += "	f.write('\\n# - Grove - Ultrasonic Ranger')" + "\r\n";
	code += "	f.write('\\n#   AKA Sciencethic 651 014')" + "\r\n";
	code += "	f.write('\\n# - Sciencethic 651 049')" + "\r\n";
	code += "	f.write('\\nfrom ppy import Pin')" + "\r\n";
	code += "	f.write('\\nfrom ppy import udelay')" + "\r\n";
	code += "	f.write('\\nimport time')" + "\r\n";
	code += "	f.write('\\nclass USRanger(object):')" + "\r\n";
	code += "	f.write('\\n	def __init__(self,pinInit):')" + "\r\n";
	code += "	f.write('\\n		self.pin = pinInit')" + "\r\n";
	code += "	f.write('\\n	def mesureEchoMicrosSec(self):')" + "\r\n";
	code += "	f.write('\\n		self.pin.init(mode=Pin.OUT)')" + "\r\n";
	code += "	f.write('\\n		self.pin.low()')" + "\r\n";
	code += "	f.write('\\n		udelay(2)')" + "\r\n";
	code += "	f.write('\\n		self.pin.high()')" + "\r\n";
	code += "	f.write('\\n		udelay(5)')" + "\r\n";
	code += "	f.write('\\n		self.pin.low()')" + "\r\n";
	code += "	f.write('\\n		self.pin.init(mode=Pin.IN)')" + "\r\n";
	code += "	f.write('\\n		return self.pulseIn()')" + "\r\n";
	code += "	f.write('\\n	def mesureCentimeters(self):')" + "\r\n";
	code += "	f.write('\\n		return round((self.mesureEchoMicrosSec()/29/2),2)')" + "\r\n";
	code += "	f.write('\\n	def mesureInches(self):')" + "\r\n";
	code += "	f.write('\\n		return round((self.mesureEchoMicrosSec()/74/2),3)')" + "\r\n";
	code += "	f.write('\\n	def pulseIn(self,timeout=1000000):')" + "\r\n";
	code += "	f.write('\\n		begin = time.ticks_us()')" + "\r\n";
	code += "	f.write('\\n		while ( self.pin.value() is 1 ):')" + "\r\n";
	code += "	f.write('\\n			if ( time.ticks_us() - begin ) >= timeout :')" + "\r\n";
	code += "	f.write('\\n				return 0')" + "\r\n";
	code += "	f.write('\\n		while ( self.pin.value() is 0 ):')" + "\r\n";
	code += "	f.write('\\n			if ( time.ticks_us() - begin ) >= timeout :')" + "\r\n";
	code += "	f.write('\\n				return 0')" + "\r\n";
	code += "	f.write('\\n		pulseBegin = time.ticks_us()')" + "\r\n";
	code += "	f.write('\\n		while ( self.pin.value() is 1 ):')" + "\r\n";
	code += "	f.write('\\n			if ( time.ticks_us() - begin ) >= timeout :')" + "\r\n";
	code += "	f.write('\\n				return 0')" + "\r\n";
	code += "	f.write('\\n		pulseEnd = time.ticks_us()')" + "\r\n";
	code += "	f.write('\\n		return  ( pulseEnd - pulseBegin )')" + "\r\n";
	code += "	f.write('\\n# End Ultrasonic Ranger Driver')" + "\r\n";
	code += "	f.close()" + "\r\n";
	code += "except:	print('lib already exist')" + "\r\n";
	if ( !ppy.isInRAWReplMode() )
		ppy.enterRawRepl().then( _ =>{		
			return ppy.exec(code);	
		});	
	else
		 return ppy.exec(code);	
}
var checkboxvue = document.getElementsByClassName("vuechange");

for (var i = 0; i < checkboxvue.length; i++) {
    checkboxvue[i].addEventListener("change", function(){changeView()});
}

function closeMsg(){
	document.getElementById('FloatantMsg').style.display ="none"
}
function ShowAnnotation(msg, type){
	if(type == "ALERT"){
		document.getElementById('msgFloat').innerHTML = msg;
		document.getElementById('FloatantMsg').style.backgroundColor = "red";
		document.getElementById('FloatantMsg').style.display = "block";
	}else{
		document.getElementById('msgFloat').innerHTML = msg;
		document.getElementById('FloatantMsg').style.display = "block";
	}
	setTimeout(() => {
		closeMsg();
	}, 4000);

}


function themeChoix(theme) {
	if (theme == "black") {
		document.getElementById("whitetheme").checked = false;
		document.getElementById("csssheet").setAttribute("href", "css/main_blacktheme.css");
	} else if (theme == "white") {
		document.getElementById("blacktheme").checked = false;
		document.getElementById("csssheet").setAttribute("href", "css/main.css");
    }
}


function fitToscreen() {
	fit.fit();
	const dims = { cols: term.cols, rows: term.rows };
	}
	
	function debounce(func, wait_ms) {
	let timeout;
	return function (...args) {
	  const context = this;
	  clearTimeout(timeout);
	  timeout = setTimeout(() => func.apply(context, args), wait_ms);
	};
	}
	const wait_ms = 50;
	window.onresize = debounce(fitToscreen, wait_ms);

function handleReplMsg(event){
	if(userREPLInstalled){
		term.write(event);
	}
	
}
				
function replWriteMsg(msg){	
	if (!userREPLInstalled){	
		ppy.exitRawRepl(_ =>{
			ppy.sendString(msg);	
		});
	}else{
		ppy.sendString(msg);
	}	
}
var datas = [];
function isNumber(str) {
	var pattern = /^\d+$/;
	return pattern.test(str);  // returns a boolean
}

var stringtoREPL= "";
term.onData((data) => {
	ppy.sendString(data);
});
// Définir une variable pour suivre l'état de la vérification
var verificationTerminee = false;

this.ppy = new PlugPyCommunicator();

this.ppy.registerConnectionStateCallback(function(stateCode){
	
	switch(stateCode){
			
		// Connecting... / En connexion
		case PlugPyCommunicator.CONN_STATE_CONNECTING : {
			if (this.stateLabelElement != null)
				this.stateLabelElement.innerHTML = "Connecting...";
		} break;
		
		// Connected / Connecté
		case PlugPyCommunicator.CONN_STATE_CONNECTED : {
			document.getElementById('coBtn').classList.remove("shakeanim");
			ShowAnnotation("Appareil associé");
			setTimeout(() => {
				closeMsg();
			}, 5000);

			stateconnected = true;
			if (this.stateLabelElement != null)
				this.stateLabelElement.innerHTML = "Connected";
					
			if (this.connectionButton != null)
				this.connectionButton.value = "Disconnect";	
				
			if(!ppy.isInRAWReplMode){
				verificationTerminee = false; // Réinitialiser l'état de la vérification
			}

			ppy.enterRawRepl().then(function(res){	
				initPPy();
				setTimeout(() => {
					ImportLibAfficheur();
					setTimeout(() => {
						ImportLibTone();
						setTimeout(() => {
							ImportLibI2C();
							setTimeout(() => {
								ImportLibLCD();
								setTimeout(() => {
									ImportLibRanger();
									verificationTerminee = true; // Marquer la vérification comme terminée
									ShowAnnotation("Vérification des librairies terminée")
								}, 1400);
							}, 1400);
						}, 1400);
					}, 1400);
				}, 1400);

				ppy.registerRXRAWCb(function(rawStrIn){
					term.write(rawStrIn);		
					GrosChiffrePushData(rawStrIn);
				});		
			});
		} break;
		
		// Disconnected / deconnecté
		case PlugPyCommunicator.CONN_STATE_DISCONNECTED : {
			stateconnected = false;
			document.getElementById('coBtn').classList.add("shakeanim");
			if (this.stateLabelElement != null)
				this.stateLabelElement.innerHTML = "Disconnected";
					
			if (this.connectionButton != null)
				this.connectionButton.value = "Connect";
		} break;
		
		case PlugPyCommunicator.STATE_BUSY: {
			document.getElementById("BS_Background").style.display = "block";
			document.getElementById("loader").style.display = "block";
		} break;
		
		case PlugPyCommunicator.STATE_IDLE: {
			// Vérifier si la vérification est terminée
			if (verificationTerminee) {
				document.getElementById("BS_Background").style.display = "none";
				document.getElementById("loader").style.display = "none";
			} else {
				// Laisser le loader affiché si la vérification n'est pas terminée
				document.getElementById("BS_Background").style.display = "block";
				document.getElementById("loader").style.display = "block";
			}
		} break;
		
		default : 
			// console.log("unhandled connection state (stateCode : "+stateCode+")");
	}
});

window.onbeforeunload = function(event)
{
	if ( ppy.isInRAWReplMode() ){
		ppy.exitRawRepl(function(){
			ppy.sendCtrlKey(0x03);
		});				
	}else{
		ppy.sendCtrlKey(0x03);
	}	
	// ppy.disconnect();
};

function tryGrosChiffreParseJson(inVal){	
    outJsonParse = null;
	try {
		outJsonParse = JSON.parse(inVal);
	}catch(Err){
		outJsonParse = []
	}
	return outJsonParse;	
}

function openHelpPanel(){
	document.getElementById('BS_Background').style.display = "block";
	document.getElementById('HelpPanel').style.display = "block";
}
function closeHelpPanel(){
	document.getElementById('helpvid').pause();
	document.getElementById('BS_Background').style.display = "none";
	document.getElementById('HelpPanel').style.display = "none";
}

document.getElementById("blocklyDiv").addEventListener('resize', function(event){
	Blockly.svgResize(workspace);
});

function connectionPPY() {
	// if (ConnectionType == false) {
	// 	console.warn("TODO BLE CONNECTION");
	// } else if (ConnectionType == true) {
	// 	console.warn("TODO USB CONNECTION");
    // }
    ppy.connectDisconnect();
    
}
document.getElementById('ConBtn').addEventListener('click', connectionPPY);


function initPPy() {
	var cmd = "";	
	cmd += "import os" + "\r\n";
	cmd += "try :" + "\r\n";
	cmd += "    os.mkdir('\\Projet')" + "\r\n";
	cmd += "except : print('\\nFolder Projet already exist')" + "\r\n";
	if ( !ppy.isInRAWReplMode() )
		ppy.enterRawRepl().then( _ =>{		
			return ppy.exec(cmd);	
		});	
	else
		return ppy.exec(cmd);	
}


var fullscreen = false;
function HandleView(viewclick, idclicked){
	console.log(document.getElementById(idclicked));
	var v = document.getElementById(idclicked).childNodes[1].getAttribute("src");
			// if (document.getElementById(idclicked).src != "ressource/svg/003-fenetre.svg"){
			if (v != "ressource/svg/003-fenetre.svg"){
				// document.getElementById(idclicked).src = "ressource/svg/003-fenetre.svg";
				v = "ressource/svg/003-fenetre.svg";
				fullscreen = true;
				MaximizeView(viewclick);
				editor.refresh();
				// reInitChart();

			}else{
				// document.getElementById(idclicked).innerHTML = "🗖";
				// document.getElementById(idclicked).src = "ressource/svg/002-agrandir-la-fenetre.svg";
				v = "ressource/svg/002-agrandir-la-fenetre.svg";
				fullscreen = false;
				ResizeView(viewclick);	
				editor.refresh();
				// reInitChart();

			}
		document.getElementById(idclicked).childNodes[1].setAttribute("src", v);

}

function Save(){

}

function MaximizeView(viewclick){
	var ParentViewContainer = document.getElementById('Views');
	ParentViewContainer.childNodes.forEach(element => {
		if(element.id != undefined){
			if(element.id != viewclick){
				element.style.display = "none";
			}
			
			if(viewclick == "editor"){
				document.querySelector(".CodeMirror").style.height = "87vh"
			}
			if(viewclick == "Blockly"){
				Blockly.svgResize(workspace);
			}
			
		}
		
	});
}
function ResizeView(viewclick){
	let ContainerofcheckboxContainer = document.getElementById("dropdownVue");
	if(viewclick == "Blockly"){
		Blockly.svgResize(workspace);
	}
	ContainerofcheckboxContainer.childNodes.forEach(element => {
		if(element.id != undefined){
			let checkboxContainer = element;
			checkboxContainer.childNodes.forEach(element2 => {
				if(element2.type == "checkbox"){
					if(element2.checked){
						document.getElementById(element2.name).style.display = "block";
					}else{
						document.getElementById(element2.name).style.display = "none";
					}	
				}
			});
			
		}
	});
	Blockly.svgResize(workspace);
	

	// InitGrosChiffre();
	// initChartConf();
}

function OpenPref(){
	document.getElementById("PrefMenu").style.display ="block";
}
function fermerPref(view){
	if(view == "pref"){
		document.getElementById("PrefMenu").style.display ="none";
	}
	
}

function FermerVueActive(view){
	document.getElementsByName(view).forEach(element => {
		if(element.type == "checkbox"){
			element.checked = false;
		}
	});
	document.getElementById(view).style.display = "none";
	if(view != "Blockly"){
		Blockly.svgResize(workspace);
	}

}
function AfficheNavig(){
	document.getElementById('BS_Background').style.display = "block";
	if(stateconnected == true){
		document.getElementById('NavigationChoixMenu').style.display = "block";
		// document.getElementById('ChoixPlugPy').style.display = "block";
	}else {
		document.getElementById('NavigationChoixMenu').style.display = "block";
		document.getElementById('ChoixPlugPy').style.display = "none";
	}
}
function FermerOptionNavig(){
	document.getElementById('NavigationChoixMenu').style.display = "none";
	document.getElementById('BS_Background').style.display = "none";
}
function FermerNavig(){
    document.getElementById('NavFileContainer').style.display = "none";
	document.getElementById('NavFile').style.display = "none";

}
function displayFileContent(res){
	ppyFileSystem.displayContent(res);
 }
 
 var OpenProjet = false;
//  document.getElementById('refreshFSTress').addEventListener('click', function(){
// 		 ppyFileSystem.refreshFileContent(displayFileContent);
// 		 ppyFileSystem.reloadFsContent();
//  });
var currenFilePath = "";
function OpenOnPPY(){
	FermerOptionNavig();
	OpenProjetPanel();
	
}
function FermerSLocal(){
	document.getElementById("BS_Background").style.display = "none";
	document.getElementById("SLocalMenu").style.display = "none";
}
function OpenInLocal(){
	FermerOptionNavig();
	document.getElementById("BS_Background").style.display = "block";
	document.getElementById("SLocalMenu").style.display = "block";
}
function OpenProjetPanel(){
	document.getElementById("NavFile").style.display = "block";
	document.getElementById("NavFileContainer").style.display = "block";
	setTimeout(() => {
		document.getElementById("refreshFSTress").click();
	}, 200);
}
function BackProjet(){
	document.getElementById("formNewProjet").style.display = "none";
	document.getElementById("BS_Background").style.display = "none";
}
function OpenNewProjet(){
	document.getElementById('NavigationLocalMenu').style.display = "none"
	// document.getElementById('BS_Background').style.display = "block";
	document.getElementById('formNewProjet').style.display = "block";
	
}
function submitForm(){
	if(document.getElementById('NamProjet').value != ""){
		projetName = document.getElementById('NamProjet').value;
		currenFilePath = projetName;
		// SaveProjet();
		// this.ppyFileSystem.NewProjet(projetName);
		// SaveProjet();
		// SaveInFile();
		Saveblk();
		document.getElementById('BS_Background').style.display = "none";
		document.getElementById('formNewProjet').style.display = "none";
	}else {
		window.alert("Veuillez remplir le champ vide !")
	}
}
 
var OpenProjet = false;
//  document.getElementById('refreshFSTress').addEventListener('click', function(){
// 		 ppyFileSystem.refreshFileContent(displayFileContent);
// 		 ppyFileSystem.reloadFsContent();
//  });
var currenFilePath = "";
function OpenOnPPY(){
	FermerOptionNavig();
	OpenProjetPanel();
	
}
function FermerNavigLocal(){
	document.getElementById("BS_Background").style.display = "none";
	document.getElementById("NavigationLocalMenu").style.display = "none";
}
function OpenInLocal(){
	FermerOptionNavig();
	document.getElementById("BS_Background").style.display = "block";
	document.getElementById("NavigationLocalMenu").style.display = "block";
}
function OpenProjetPanel(){
	document.getElementById("NavFile").style.display = "block";
	document.getElementById("NavFileContainer").style.display = "block";
	setTimeout(() => {
		document.getElementById("refreshFSTress").click();
	}, 200);
}
function BackProjet(){
	document.getElementById("formNewProjet").style.display = "none";
	document.getElementById("BS_Background").style.display = "none";
}
function OpenNewProjet(){
	document.getElementById('NavigationLocalMenu').style.display = "none"
	// document.getElementById('BS_Background').style.display = "block";
	document.getElementById('formNewProjet').style.display = "block";
	
}
function submitForm(){
	if(document.getElementById('NamProjet').value != ""){
		projetName = document.getElementById('NamProjet').value;
		currenFilePath = projetName;
		// SaveProjet();
		// this.ppyFileSystem.NewProjet(projetName);
		// SaveProjet();
		// SaveInFile();
		Saveblk();
		document.getElementById('BS_Background').style.display = "none";
		document.getElementById('formNewProjet').style.display = "none";
	}else {
		window.alert("Veuillez remplir le champ vide !")
	}
}
var newProjetName;

function requestFsContent(fsContentCB){
	var cmd = "";	
	cmd += "import json" + "\r\n";
	cmd += "from os import ilistdir" + "\r\n";
	cmd += "def listFsElement(path,filterTypeFile) : " + "\r\n";
	cmd += "    res = []" + "\r\n";
	cmd += "    try : " + "\r\n";
	cmd += "        for fsItem in ilistdir(path) : " + "\r\n";
	
	// if (this.appPref[prefIndexBolOnlyDisplayPythonExecutableFiles]){
		// cmd += "            if filterTypeFile and fsItem[1] == 0x8000 and \".py\" in fsItem[0] : " + "\r\n";
	// }else{
	cmd += "            if filterTypeFile and fsItem[1] == 0x8000 : " + "\r\n";
	// }
	cmd += "                res.append(fsItem[0])" + "\r\n";
	cmd += "            elif not(filterTypeFile) and fsItem[1] != 0x8000 : " + "\r\n";
	// if (this.appPref[prefIndexBolHideSystemFilesFolders]){
		// cmd += "                if \"System Volume Information\" not in fsItem[0] and \"conf\" not in fsItem[0] : " + "\r\n";
	// }else{
	// cmd += "                if \"System Volume Information\" not in fsItem[0] and \"Fichier Recent\" not in fsItem[0] : " + "\r\n";
	cmd += "                if \"System Volume Information\" not in fsItem[0] and \"TP\" not in fsItem[0] and \"conf\" not in fsItem[0] and \"lib\" not in fsItem[0]  and \"MiscTools\" not in fsItem[0]: " + "\r\n";
	// }	
	cmd += "                    res.append(fsItem[0])" + "\r\n";
	cmd += "    except : pass" + "\r\n";
	cmd += "    return res" + "\r\n";
	cmd += "def discoverFs(out,currentPath) : " + "\r\n";		
	cmd += "    out += listFsElement(currentPath,True)" + "\r\n";
	cmd += "    for folderName in listFsElement(currentPath,False) : " + "\r\n";
	cmd += "        tempDirContent = [folderName] " + "\r\n";
	cmd += "        if currentPath != \"\" : " + "\r\n";
	cmd += "            folderName = '/'+folderName" + "\r\n";
	cmd += "        discoverFs(tempDirContent,currentPath+folderName)" + "\r\n";
	cmd += "        out.append(tempDirContent)" + "\r\n";
	cmd += "fsElement = []" + "\r\n";
	cmd += "discoverFs(fsElement,\"\")" + "\r\n";
	cmd += "print(json.dumps(fsElement))" + "\r\n";
	if ( !ppy.isInRAWReplMode() )
		ppy.enterRawRepl().then(function(res){		
			ppy.exec(cmd).then(function(res){		
				tryParseFsAnswer(res,fsContentCB);
			});
			
		});	
	else
		ppy.exec(cmd).then(function(res){
			tryParseFsAnswer(res,fsContentCB);

		});

}
function removeFolder(folderPath,cbDone=null){
	var cmd = "";	
	cmd += "from os import ilistdir,remove,rmdir" + "\r\n";
	cmd += "def discoverFoldersRemoveFiles(tmp,folders,folderPath) :" + "\r\n";
	cmd += "	res = []" + "\r\n";
	cmd += "	for fsItem in ilistdir(folderPath) :" + "\r\n";
	cmd += "		if fsItem[1] == 0x8000 :" + "\r\n";
	cmd += "			remove(folderPath+\"/\"+fsItem[0])" + "\r\n";
	cmd += "		elif fsItem[1] != 0x8000 :" + "\r\n";
	cmd += "			res.append(fsItem[0])" + "\r\n";
	cmd += "	for folderName in res :" + "\r\n";
	cmd += "		tempDirContent = [folderName]" + "\r\n"; 
	cmd += "		folderName = \"/\"+folderName" + "\r\n";
	cmd += "		discoverFoldersRemoveFiles(tempDirContent,folders,folderPath+folderName)" + "\r\n";
	cmd += "		folders.append(folderPath+folderName)" + "\r\n";
	cmd += "		tmp.append(folderName)" + "\r\n";
	cmd += "tmp = []" + "\r\n";
	cmd += "folders = []" + "\r\n";
	cmd += "discoverFoldersRemoveFiles(tmp,folders,\""+folderPath.substr(1)+"\")" + "\r\n";
	cmd += "for folderPath in folders :" + "\r\n";
	cmd += "	rmdir(folderPath)" + "\r\n";
	cmd += "rmdir(\""+folderPath.substr(1)+"\")" + "\r\n";
	if ( !ppy.isInRAWReplMode() )
		ppy.enterRawRepl().then(function(res){		
			ppy.exec(cmd).then(function(res){
				if (cbDone !=null)
					cbDone("OK");
			});
		});
	else
		ppy.exec(cmd).then(function(res){
			if (cbDone !=null)
				cbDone("OK");
		});
}
function makeFolder(folderPath,cbDone=null){
	var cmd = "";
	cmd += "import os" + "\r\n";
	cmd += "os.mkdir(\""+folderPath.substr(1)+"\")" + "\r\n";
	if ( !ppy.isInRAWReplMode() )
		ppy.enterRawRepl().then(function(res){		
			ppy.exec(cmd).then(function(res){
				if (cbDone !=null)
					cbDone("OK");
			});
		});
	else
		ppy.exec(cmd).then(function(res){
			if (cbDone !=null)
				cbDone("OK");
		});
}

var typeOuvert = "";

document.getElementById("OpenFileLocal").addEventListener("click", function () {
    document.getElementById("filelocal").click();
});

document.getElementById("filelocal").addEventListener("change", async function () {
    typeOuvert = "local";
    
    try {
        const fileInput = this;
        if (fileInput.files && fileInput.files.length > 0) {
            const extension = fileInput.files[0].name.substr(fileInput.files[0].name.lastIndexOf('.') + 1);
            console.log("File extension:", extension);

            document.getElementById("closectrlFile").style.display = "block";
            FermerNavigLocal();

            let text = await readFileAsync(fileInput.files[0]);

            if (extension === "blk") {
                loadBlocklyFile(text, fileInput.files[0].name);
            } else {
                loadPythonFile(text, fileInput.files[0].name);
            }
        } else {
            console.error("No file selected");
        }
    } catch (error) {
        console.error("Error handling file:", error.message);
    }
});

function loadBlocklyFile(text, fileName) {
    try {
        var xml = Blockly.Xml.textToDom(text);

        if (!workspace) {
            console.error("Blockly workspace not initialized");
            return;
        }

        workspace.clear();

        var blkFileElement = document.getElementById("BlkFile");
        if (blkFileElement) {
            blkFileElement.innerHTML = fileName;
        }

        Blockly.Xml.domToWorkspace(xml, workspace);
    } catch (error) {
        console.error("Error loading Blockly file:", error.message);
        console.error("File content:", text);
    }
}

function loadPythonFile(text, fileName) {
    try {
        var res = atob(text);
        editor.setValue(res);
        
        var pyFileElement = document.getElementById("PyFile");
        if (pyFileElement) {
            pyFileElement.innerHTML = fileName;
        }
    } catch (error) {
        console.error("Error decoding file:", error.message);
        editor.setValue(text);
    }
}

function readFileAsync(file) {
    return new Promise((resolve, reject) => {
        const reader = new FileReader();

        reader.onload = (event) => {
            resolve(event.target.result);
        };

        reader.onerror = (error) => {
            reject(error);
        };

        reader.readAsText(file);
    });
}

function CloseOpenFile() {
    document.getElementById("Saveinblk").style.display = "block";
    
    var pyFileElement = document.getElementById("PyFile");
    if (pyFileElement) {
        pyFileElement.innerHTML = "PyFile";
    }
    
    var closeCtrlFileElement = document.getElementById("closectrlFile");
    if (closeCtrlFileElement) {
        closeCtrlFileElement.style.display = "none";
    }

    editor.setValue("");
}


function CloseOpenFile() {
    document.getElementById("Saveinblk").style.display = "block";
    
    // Ajouter des vérifications pour éviter les erreurs si les éléments ne sont pas présents
    var pyFileElement = document.getElementById("PyFile");
    if (pyFileElement) {
        pyFileElement.innerHTML = "PyFile";
    }
    
    var closeCtrlFileElement = document.getElementById("closectrlFile");
    if (closeCtrlFileElement) {
        closeCtrlFileElement.style.display = "none";
    }

    editor.setValue("");
}




function removeFile(filePath,cbDone=null){
	var cmd = "";
	cmd += "import os" + "\r\n";
	cmd += "os.remove(\""+filePath.substr(1)+"\")" + "\r\n";
	if ( !ppy.isInRAWReplMode() )
		ppy.enterRawRepl().then(function(res){		
			ppy.exec(cmd).then(function(res){
				if (cbDone !=null)
					cbDone("OK");
			});
		});
	else
		ppy.exec(cmd).then(function(res){
			if (cbDone !=null)
				cbDone("OK");
		});
}
function _isPPYNativeFilePath(filePath){
	if (filePath.length){
		var extention = filePath.substr(filePath.lastIndexOf('.'),filePath.length);
		if (extention == ".py" && /[^a-z0-9_()]/i.test(filePath) && !filePath.includes(' '))
			return true;
	}
	console.warn("Unsopported file.");
	return false;
}
function _checkAndExecuteFile(executeFilePath){
	if (_isPPYNativeFilePath(executeFilePath))
		executeFile(executeFilePath.substr(0,executeFilePath.lastIndexOf('.')));
}
function editorExecuteCurrentFile(){
	_checkAndExecuteFile(currenFilePath);
}
function executeFile(filePath){
	filePath = filePath.substr(1).replace(/\//g,'.');
	var cmd = "";
	cmd += "print(\"\\r\\n\")" + "\r\n";
	cmd += "import "+filePath+"\r\n";
	ppy.enterRawRepl().then(function(){
		ppy.exec(cmd,false,true).then(function(res){
			ppy.exitRawRepl();
		});
	});
}
function _checkAndSetStartUpFile(startUpFilePath){
	if (_isPPYNativeFilePath(startUpFilePath))
		setStartupFile(startUpFilePath);
}
function editorSetStartupCurrentFile(){
	_checkAndSetStartUpFile(currenFilePath);
}
function setStartupFile(filePath){
	var cmd = "";
	cmd += "file = open(\"conf/startUpFile.py\",'w')" + "\r\n";
	cmd += "file.write(\"from ppy import main\\rmain(\\\""+filePath.substr(1)+"\\\")\")" + "\r\n";
	cmd += "file.close()" + "\r\n";
	if ( !ppy.isInRAWReplMode() )
		ppy.enterRawRepl().then(function(res){		
			ppy.exec(cmd).then(function(res){
				
			});
		});
	else
		ppy.exec(cmd).then(function(res){
			
		});
}
function renameFile(filePathToName,newName,cbDone){
	var newFilePath = filePathToName.substr(0,filePathToName.lastIndexOf('/')+1)+newName;
	var cmd = "";	
	cmd += "from os import rename" + "\r\n";
	cmd += "rename(\""+filePathToName.substr(1)+"\",\""+newFilePath.substr(1)+"\")" + "\r\n";
	if ( !ppy.isInRAWReplMode() )
		ppy.enterRawRepl().then(function(res){		
			ppy.exec(cmd).then(function(res){
				if (cbDone !=null)
					cbDone("OK");
			});
		});
	else
		ppy.exec(cmd).then(function(res){
			if (cbDone !=null)
				cbDone("OK");
		});
}
function loadFileCheckPrefSaveOpenedFile(nextFilePathToBeOpen,byPassCheckPrefSave=true,doneCb=null){
	// this.nextFilePathToBeOpen = nextFilePathToBeOpen;
	// if ( byPassCheckPrefSave == false && this.appPref[prefIndexBolPromptToSaveFileIfModifiefBeforeLoadingAnotherFile] && this.currentFileIsModified && currenFilePath != "" ){
		// document.getElementById ( "bgEditorSaveBeforeOpenAnotherFile" ).style.visibility = "visible";
		// if (doneCb != null)
			// doneCb(null);		
	// }else{
		// this.currentFileIsModified = false;
		// if (doneCb != null)
			doneCb("CONTINUE");
	// }
}
function loadFile(filePath,loadCB,readSizeBlock=512,writeFileHistoryPref=true,byPassCheckPrefSave=false,updateCurrentFilePath=true){
	loadFileCheckPrefSaveOpenedFile(filePath,byPassCheckPrefSave,function(res){
		if (res == "CONTINUE"){
			
			typeOuvert = "ppy";
			CloseProjet();

			// document.getElementById("Savepy").style.display = "block";
			document.getElementById("closectrlFile").style.display = "block";
			document.getElementById("closeCntl").style.display = "none";
			// document.getElementById("Saveinblk").style.display = "none";
			editor.setValue("")
			if (updateCurrentFilePath)
				currenFilePath = filePath;
			document.getElementById("PyFile").innerHTML = currenFilePath.substr(1);
			var cmd = "";
			cmd += "from lib.base64 import b64encode" + "\r\n";
			cmd += "from os import stat" + "\r\n";
			cmd += "try : " + "\r\n";
			cmd += "    res = stat(\""+filePath.substr(1)+"\")" + "\r\n";
			cmd += "    res = \"\"" + "\r\n";
			cmd += "    file = open(\""+filePath.substr(1)+"\",\"rb\")" + "\r\n";	
			cmd += "    res = file.read("+readSizeBlock.toString()+")" + "\r\n";
			cmd += "    while len(res) : " + "\r\n";
			cmd += "        print(b64encode(b''+res).decode())" + "\r\n";
			cmd += "        res = file.read("+readSizeBlock.toString()+")" + "\r\n";
			cmd += "    file.close()" + "\r\n";	
			cmd += "except : print(\"NULL\")" + "\r\n";
			if ( !ppy.isInRAWReplMode() )
				
				ppy.enterRawRepl().then(function(res){		
					ppy.exec(cmd).then(function(res){
						
						if (res.indexOf("NULL")==0){
							loadCB(null,null);
						}else{
							readFileModificationDateTime(filePath,function(fileModificationDate){					
								// if ( this.appPref[ prefIndexBolRestoreEditorLastView ] && writeFileHistoryPref == true ){
									// this.appPref[ prefIndexStrEditorLastViewPath ] = filePath;
									// readAndWriteGUIUseDefiniedSettings(function(res1){
										// rres = "";
										// res.split("\n").forEach(function(line){rres+=atob(line)});
										// loadCB(rres,fileModificationDate);
									// });
									
								// }else{
									 FichierOuvert = filePath;
									rres = "";
									if(res != ""){
										res.split("\n").forEach(function(line){rres+=atob(line)});
									}
									loadCB(rres,fileModificationDate);
								// }
							});		
						}
						FermerNavig();						
					});
				});
			else
				ppy.exec(cmd).then(function(res){
					editor.setValue("")		
					if (res.indexOf("NULL")==0){
							loadCB(null,null);
					}else{
						readFileModificationDateTime(filePath,function(fileModificationDate){					
							// if ( this.appPref[ prefIndexBolRestoreEditorLastView ] && writeFileHistoryPref == true ){
								// this.appPref[ prefIndexStrEditorLastViewPath ] = filePath;
								// readAndWriteGUIUseDefiniedSettings(function(res1){
										// rres = "";
										// res.split("\n").forEach(function(line){rres+=atob(line)});
										// loadCB(rres,fileModificationDate);
								// });
							// }else{
								rres = "";
								FichierOuvert = filePath;
								// try{
								// 	rrres = atob(line);
								// }catch(error){
									
								// 	/* TODO, gérer erreur */
								// 	console.warn("TODO, gérer erreur");
									
								// }
								
								
								if(res != ""){
									res.split("\n").forEach(function(line){rres+=atob(line)});
								}
								loadCB(rres,fileModificationDate);
							// }
						});		
					}
				});	
			FermerNavig();			
		}	
	});	

}

function readFileModificationDateTime(filePath,doneCB=null){
	cmd = "";				
	cmd += "import os" + "\r\n";
	cmd += "print(os.stat(\""+filePath.substr(1)+"\")[8])" + "\r\n";
	ppy.exec(cmd).then(function(fileModificationDate){
			if (doneCB != null)
				doneCB(new Date((parseInt(fileModificationDate)*1000)+946656000000).toLocaleString());
	});
}

this.ppyFileSystem = new PlugPyFileSystem("","",
	function(editFilePath){
		var extention = editFilePath.substr(editFilePath.lastIndexOf('.'),editFilePath.length);
		console.log(extention)
		if (extention == ".txt" || extention == ".htm" || extention == ".html" || extention == ".py" || extention == ".js" || extention == ".inf"|| extention == ".log"){
			loadFile(editFilePath,function(res,lastModificationDate){
				// mooveToEditor();
				// addTofichierRecent(editFilePath);
				if(res != null){
					editor.setValue(res);
				}
			
			// document.getElementById("currentFileUl").childNodes[1].innerText = editFilePath.substr(editFilePath.lastIndexOf('/')+1);
			// document.getElementById("currentFileUl").childNodes[3].innerText = lastModificationDate;setEditorPyFileBtnActionState(extention == ".py");
			});
		}else if(extention == ".blk"){
			loadFile(editFilePath,function(res,lastModificationDate){
				    // addTofichierRecent(editFilePath);
					if(res != null){
						xml_text = Blockly.Xml.domToText(xml);
						xml = Blockly.Xml.textToDom(xml_text);
						searchInXml(xml_text);
						workspace.clear();
						Blockly.Xml.domToWorkspace(xml, workspace);
					}
			});
		}else{
			console.warn("(to editor) Unsopported file format ("+extention+")");
			ShowAnnotation("Format non supporté", "ALERT");
			setTimeout(() => {
				closeMsg();
			}, 2000);
			
		}
	},
	function(){requestFsContent(function(res){ppyFileSystem.reloadFsContent(res);});},
	function(removeFilePath){removeFile(removeFilePath,function(res){requestFsContent(function(res){ppyFileSystem.reloadFsContent(res);});});},
	function(executeFilePath){_checkAndExecuteFile(executeFilePath);},
	function(startUpFilePath){_checkAndSetStartUpFile(startUpFilePath);},
	function(filePathToName,newName){renameFile(filePathToName,newName,function(res){requestFsContent(function(res){ppyFileSystem.reloadFsContent(res);if (filePathToName == currenFilePath){document.getElementById("currentFileUl").childNodes[1].innerText = newName;currenFilePath = filePathToName.substr(0,filePathToName.lastIndexOf('/')+1)+newName;}});});},
	function(removeFolderPath){removeFolder(removeFolderPath,function(res){requestFsContent(function(res){ppyFileSystem.reloadFsContent(res);});});},
	function(newFolderPath, cbDone=null){
		makeFolder(newFolderPath,function(res){
			requestFsContent(function(res){
				ppyFileSystem.reloadFsContent(res);
			});
		});
	},
	function(newFileAtPath, cbDone=null){
		// editor.setValue("# My new file, created on "+new Date().toLocaleString()+" .");
		currenFilePath = newFileAtPath;
		editorSaveCurrentFile(function(res){
			
			// var extention = newFileAtPath.substr(newFileAtPath.lastIndexOf('.'),newFileAtPath.length);
			// if (extention == ".txt" || extention == ".htm" || extention == ".html" || extention == ".py" || extention == ".js" || extention == ".inf" || extention == ".blk"){
				// loadFile(newFileAtPath,function(res,lastModificationDate){
					// editor.setValue(res);document.getElementById("currentFileUl").childNodes[1].innerText = newFileAtPath.substr(newFileAtPath.lastIndexOf('/')+1);
					// document.getElementById("currentFileUl").childNodes[3].innerText = lastModificationDate;
					// requestFsContent(function(res){ppyFileSystem.reloadFsContent(res);
					// });
				// });
			// }else 
			requestFsContent(function(res){
				ppyFileSystem.reloadFsContent(res);
			// }
			});
		},true);	
	},
	project_name => {
		currenFilePath = "/Projet/" + project_name;
		
		var cmd =
			"try:" + "\r\n"+ 
			"  import os" + "\r\n"+
			"  os.mkdir('Projet\\"+project_name+"')" + "\r\n"+
			"  file = open('Projet\\"+project_name+"\\"+project_name+".blk','w')" + "\r\n"+
			"  file.close()" + "\r\n"+
			"  file = open('Projet\\"+project_name+"\\"+project_name+".py','w')" + "\r\n"+
			"  file.close()" + "\r\n"+
			"except : print(\"Projet deja existant\")" + "\r\n";
					
		return ppy.exec(cmd);		
		
	},
	function(openprojetPath){
		OpenProjetWorkspace(openprojetPath, function(py, blk){
			currenFilePath = openprojetPath;
			document.getElementById("openFileCOntainer").innerHTML = "Projet : " + openprojetPath.substr(openprojetPath.lastIndexOf('/')+1);
			console.log(py)
			editor.setValue(py)
			importBlocks(blk)

		});
		
	}
);
function CloseProjet(){
	document.getElementById("openFileCOntainer").innerHTML = "Projet : ";
	document.getElementById("PyFile").innerHTML = "PyFile";
	document.getElementById("BlkFile").innerHTML = "BlkFile";
	document.getElementById("closeCntl").style.display = "none";

	editor.setValue("");
	workspace.clear();
	currenFilePath = "";
}function SaveProjet() {
    if (stateconnected == true) {
        let strFilePartPy = btoa(editor.getValue());

        var xml = Blockly.Xml.workspaceToDom(workspace);
        var xml_text = Blockly.Xml.domToText(xml);

        // Utiliser une chaîne vide comme espace de travail par défaut
        if (!xml_text.trim()) {
            xml_text = '';
        }

        let strFilePartBlk = btoa(xml_text);

        console.log(strFilePartBlk, xml_text);
        console.log(strFilePartPy, editor.getValue());

        if (currenFilePath != "") {
            var cmd = "";
            cmd += "file = open(\"" + currenFilePath.substr(1) + currenFilePath.substr(currenFilePath.lastIndexOf("/")) + ".py\",'w')" + "\r\n";
            cmd += "file.write('" + strFilePartPy + "')" + "\r\n";
            cmd += "file.close()" + "\r\n";
            cmd += "file = open(\"" + currenFilePath.substr(1) + currenFilePath.substr(currenFilePath.lastIndexOf("/")) + ".blk\",'w')" + "\r\n";
            cmd += "file.write(\"" + strFilePartBlk + "\")" + "\r\n";
            cmd += "file.close()" + "\r\n";
            console.log(cmd);

            if (!ppy.isInRAWReplMode()) {
                ppy.enterRawRepl().then(function (res) {
                    ppy.exec(cmd).then(function (res) {
                        // Traitement supplémentaire si nécessaire
                    });
                });
            } else {
                ppy.exec(cmd).then(function (res) {
                    // Traitement supplémentaire si nécessaire
                });
            }
        } else {
            OpenNewProjet();
        }

    } else {
        connectionPPY();
    }
}

function SaveInFile(){
	Saveblk();
	let strFilePart = btoa(editor.getValue()); 		
	if(typeOuvert == "local"){
		let filePath = filelocal.files[0].name;
		try { 
			var link = document.createElement('a');
			link.download= filePath;
			link.href="data:application/octet-stream;utf-8," + encodeURIComponent(editor.getValue());
			document.body.appendChild(link);
			link.click();
			link.remove();
		  } catch (e) {
			window.location.href="data:application/octet-stream;utf-8," + encodeURIComponent(editor.getValue());
			alert(e);
		  }
		
	}else{
		let filePath = FichierOuvert;
		var cmd = "";
		// cmd += "from lib.base64 import b64decode" + "\r\n";	
		cmd += "file = open(\""+filePath.substr(1)+"\",'w')" + "\r\n";	
		strFilePart = btoa(strFilePart);
		// cmd += "file.write(b64decode(\""+strFilePart+"\"))" + "\r\n";
		cmd += "file.write('"+strFilePart+"')" + "\r\n";
		cmd += "file.close()" + "\r\n";	
		
		console.warn(cmd);
		if ( !ppy.isInRAWReplMode() )
			ppy.enterRawRepl().then(function(res){		
				ppy.exec(cmd).then(function(res){
					
				});
			})
		else
			ppy.exec(cmd).then(function(res){
				
			});		
	}


	
}
function OpenProjetWorkspace(path, loadProjetCB, paquet = 64){

	document.getElementById("PyFile").innerHTML = path.substr(path.lastIndexOf("/")+1) + ".py";
	document.getElementById("BlkFile").innerHTML = path.substr(path.lastIndexOf("/")+1) + ".blk";
	// document.getElementById("Savepy").style.display = "none";
	document.getElementById("closectrlFile").style.display = "none";
	document.getElementById("closeCntl").style.display = "inline-block";
	document.getElementById("Saveinblk").style.display = "block";

	var code = "from lib.base64 import b64encode" + "\r\n";
	code += "from os import stat, ilistdir" + "\r\n";
	code += "try :" + "\r\n";
	code += "	path = \""+path.substr(1)+"\"" + "\r\n";
	code += "	resAll = \"\"" + "\r\n";
	code += "	for item in ilistdir(path):" + "\r\n";
	code += "		if \".blk\" in item[0] :" + "\r\n";
	code += "			pathItem = path + \"/\"+ item[0]" + "\r\n";
	// code += "			print(pathItem)" + "\r\n";
	code += "			resblk = stat(pathItem)" + "\r\n";
	code += "			resblk = \"\"" + "\r\n";
	code += "			file = open(pathItem,\"rb\")" + "\r\n";
	code += "			resblk = file.read("+paquet.toString()+")" + "\r\n";
	code += "			while len(resblk) :" + "\r\n";
	code += "				resAll += b64encode(b''+resblk).decode() + \"\\n\"" + "\r\n";
	// code += "				print(b64encode(b''+resblk).decode())" + "\r\n";
	code += "				resblk = file.read("+paquet.toString()+")" + "\r\n";
	code += "			file.close()" + "\r\n";
	code += "			resAll += \",\"" + "\r\n";
	code += "		if \".py\" in item[0]:" + "\r\n";
	code += "			pathItem = path + \"/\"+ item[0]" + "\r\n";
	// code += "			print(pathItem)" + "\r\n";
	code += "			res = stat(pathItem)" + "\r\n";
	code += "			res = \"\"" + "\r\n";
	code += "			file = open(pathItem,\"rb\")" + "\r\n";
	code += "			res = file.read("+paquet.toString()+")" + "\r\n";
	code += "			while len(res) :" + "\r\n";
	code += "				resAll += b64encode(b''+res).decode() + \"\\n\"" + "\r\n";
	code += "				res = file.read("+paquet.toString()+")" + "\r\n";
	code += "			file.close()" + "\r\n";
	code += "			print(resAll)" + "\r\n";
	code += "except : print(\"Erreur de lecture de fichier\")" + "\r\n";
	if ( !ppy.isInRAWReplMode() )
				
		ppy.enterRawRepl().then(function(res){		
			ppy.exec(code).then(function(res){
					editor.setValue("")		
			
					let respy = "";
					let ressblk = "";

					let blk = "";
					let py = "";
					FichierOuvert = "";
					if(res != ""){
						res.split(',').forEach(function(line){
							if(ressblk == ""){
								ressblk+= line
							}else{
								respy+= line
							}
						});
						ressblk.split("\n").forEach(function(line){blk+=atob(atob(line))});	
						respy.split("\n").forEach(function(line){py+=atob(atob(line))});						
					}	
					loadProjetCB(py,blk);
				FermerNavig();						
			});
		});
	else
	ppy.exec(code).then(function(res){
		editor.setValue("")		
		
				let respy = "";
				let ressblk = "";

				let blk = "";
				let py = "";
				FichierOuvert = "";
				if(res != ""){
					res.split(',').forEach(function(line){
						if(ressblk == ""){
							ressblk+= line
						}else{
							respy+= line
						}
					});
					console.log(ressblk, respy)
					ressblk.split("\n").forEach(function(line){blk+=atob(atob(line))});	
					respy.split("\n").forEach(function(line){py+=atob(atob(line))});						
				}
				
				loadProjetCB(py,blk);
		});	
	FermerNavig();

}


/////////////////////////////////////// ADD BLOCKLY ////////////////////////////////////////////

function importBlocks(xml_text) {
  try {
    // var xml_text = prompt("Please enter XML code", "");
    var xml = Blockly.Xml.textToDom(xml_text);
	searchInXml(xml_text);
    workspace.clear();
    Blockly.Xml.domToWorkspace(xml, workspace);
  } catch (e) {
    
  }
}	function Saveblk() {
    try {
        console.log(editor.getValue());
        var xml = Blockly.Xml.workspaceToDom(workspace);
        var xml_text = Blockly.Xml.domToText(xml);

        // Utiliser une chaîne vide comme espace de travail par défaut
        if (!xml_text.trim()) {
            xml_text = '';
        }

        var link = document.createElement('a');
        link.download = currenFilePath + ".blk";
        link.href = "data:application/octet-stream;utf-8," + encodeURIComponent(xml_text);
        document.body.appendChild(link);
        link.click();
        link.remove();

        var link_py = document.createElement('a');
        link_py.download = currenFilePath + ".py";
        link_py.href = "data:application/octet-stream;utf-8," + encodeURIComponent(editor.getValue());
        document.body.appendChild(link_py);
        link_py.click();
        link_py.remove();
    } catch (e) {
        window.location.href = "data:application/octet-stream;utf-8," + encodeURIComponent(xml_text);
        alert(e);
    }
}


var ppyBlocksSpe = [];
function autoecriture(event) {
  
	let outputCode = "";
	let imports = "";
	let inits = "";
  
	ppyBlocksSpe.forEach(function(dico){
	  		
		imports += "from "+dico.importLib+" import "+dico.importType+"\n";
		inits += dico.initBit+"\n";

	});
	  
	outputCode += imports +"\r\n";
	outputCode += inits +"\r\n";
	outputCode += Blockly.Python.workspaceToCode(workspace);
	
	editor.setValue(outputCode);
	
	
}
var xml = Blockly.Xml.workspaceToDom(workspace);
var xml_text = Blockly.Xml.domToText(xml);

workspace.addChangeListener(autoecriture);

function controlLib(event) {
	if(event.type == Blockly.Events.BLOCK_CREATE){
		var xml = new XMLSerializer().serializeToString(event.xml);
		if(xml.includes('oled')){
			let importLib = "ppy";
			let importType = "Oled";
			let initBit = "screen = Oled()"; 
			let strucProp = 
			{
				importLib:importLib,
				importType:importType,
				initBit:initBit
			};		
			checkForImport(strucProp);	
		}else if(xml.includes('delay')){
			let importLib = "ppy";
			let importType = "delay";
			let initBit = ""; 
			let strucProp = 
			{
				importLib:importLib,
				importType:importType,
				initBit:initBit
			};	
			checkForImport(strucProp);		
		}else if(xml.includes('switch')){
			let importLib = "ppy";
			let importType = "Switch";
			let initBit = "userSwitch = Switch()"; 
			let strucProp = 
			{
				importLib:importLib,
				importType:importType,
				initBit:initBit
			};		
			checkForImport(strucProp);
		}else if(xml.includes('lcd')){
			let importLib = "lib.LCD16x2RGB";
			let importType = "LCD16x2RGB as LCD";
			let initBit = "lcd = LCD()"; 
			let strucProp = 
			{
				importLib:importLib,
				importType:importType,
				initBit:initBit
			};	
			checkForImport(strucProp);
		}else if(xml.includes('milli')){
			let importLib = "ppy";
			let importType = "millis";
			let initBit = ""; 
			let strucProp = 
			{
				importLib:importLib,
				importType:importType,
				initBit:initBit
			};	
			checkForImport(strucProp);
		
		}else if(xml.includes("banane")){
			graphUpdateGraphTitle("Tension en fonction du temps");
			graphUpdateYaxesLeftTitle("Tension (en V)");
			InitTableur("Tension (en V)", "Temps (en ms)");

		}else if(xml.includes("aqcuisition_nbdonnee")){
			graphUpdateTimeLegeng("Temps (en s)");

		}else if(xml.includes("thermometre")){
			graphUpdateGraphTitle("Température en fonction du temps");
			graphUpdateYaxesLeftTitle("Température (en °C)");
			InitTableur("Température (en °C)", "Temps (en s)");

		}else if(xml.includes("station_co2")){

			graphUpdateGraphTitle("CO2 dans l'air en fonction du temps");
			graphUpdateYaxesLeftTitle("Particules par million (en PPM)");

		}else if(xml.includes("pression")){
			graphUpdateGraphTitle("Pression en fonction de 1 / Volume");
			graphUpdateYaxesLeftTitle("Pression (en hPa)");
			graphUpdateTimeLegeng("1 / Volume (mL)");
			InitTableur("Pression (en hPa)", "1 / Volume (mL)");

		}else if(xml.includes("exao_capteurtelemetre")){
			graphUpdateGraphTitle("Télemètre");
			graphUpdateYaxesLeftTitle("Distance (en m)");
			InitTableur("Distance (en m)", "Temps (en s)");			
		
		}else if(xml.includes("hydro")){
			graphUpdateGraphTitle("Pression en fonction de la profondeur");
			graphUpdateYaxesLeftTitle("Pression (en hPa)");
			graphUpdateTimeLegeng("Profondeur (en cm)");
			InitTableur("Pression (en hPa)", "Profondeur (en cm)");

		}else if(xml.includes("usranger")){
			graphUpdateGraphTitle("Temps de propagation des ultrasons en fonction d'une distance");
			graphUpdateYaxesLeftTitle("Distance (en m)");
			graphUpdateTimeLegeng("Temps de propagation (en s)");
			InitTableur("Distance (en m)", "Temps de propagation (en m)");
		}
		reInitChart();
	}else if(event.type == Blockly.Events.BLOCK_DELETE){
		var xml = new XMLSerializer().serializeToString(event.oldXml);
		var allblocks = new XMLSerializer().serializeToString(Blockly.Xml.workspaceToDom(workspace));	
		if(xml.includes('oled')){
			if(!allblocks.includes('oled')){
				var index = ppyBlocksSpe.indexOf(ppyBlocksSpe.find(strucProp => strucProp.importType === 'Oled'));
				ppyBlocksSpe.splice(index, 1);
			}

		}else if(xml.includes('delay')){
			if(!allblocks.includes('delay')){
				var index = ppyBlocksSpe.indexOf(ppyBlocksSpe.find(strucProp => strucProp.importType === 'delay'));
				ppyBlocksSpe.splice(index, 1);
			}

		}else if(xml.includes('lcd')){
			if(!allblocks.includes('lcd')){
				var index = ppyBlocksSpe.indexOf(ppyBlocksSpe.find(strucProp => strucProp.importType === 'lcd'));
				ppyBlocksSpe.splice(index, 1);
			}

		}else if(xml.includes('switch')){
			if(!allblocks.includes('switch')){
				var index = ppyBlocksSpe.indexOf(ppyBlocksSpe.find(strucProp => strucProp.importType === 'Switch'));
				ppyBlocksSpe.splice(index, 1);				
			}

		}else if (xml.includes('exao')){
			ReinitTableur(1);
			reInitChart();
			
		}else if (xml.includes('milli')){
			if(!allblocks.includes('milli')){
			var index = ppyBlocksSpe.indexOf(ppyBlocksSpe.find(strucProp => strucProp.importType === 'millis'));
			ppyBlocksSpe.splice(index, 1);				
		}
	}
	// graphUpdateGraphTitle("MyGraph");
	// graphUpdateYaxesLeftTitle("");
	// graphUpdateTimeLegeng(formatTimeAxisStr(samplingRate));
	graphConfig = initChartConf(
		title = formatTitle(null,null),		
		serieColor = [['rgb(255,0,0)',strYAxisLeft],['rgb(0,255,0)',strYAxisRight]],
		xAxisCaption = formatTimeAxisStr(samplingRate),
		gridLinesColor = "#dee6ef",
		leftYaxisCaption = strYAxisLeft,
		rightYaxisCaption = strYAxisRight,
		prevChartConf = null
	);
	reInitChart();
	InitGrosChiffre();
	}

}


workspace.addChangeListener(controlLib);
function searchInXml(xml_text){
	
	if(xml_text.includes('oled')){
		let importLib = "ppy";
		let importType = "Oled";
		let initBit = "screen = Oled()"; 
		let strucProp = 
		{
			importLib:importLib,
			importType:importType,
			initBit:initBit
		};	
		checkForImport(strucProp);		
	} 
	if(xml_text.includes('delay')){
		let importLib = "ppy";
		let importType = "delay";
		let initBit = ""; 	
		let strucProp = 
		{
			importLib:importLib,
			importType:importType,
			initBit:initBit
		};				
		checkForImport(strucProp);
	}
	if(xml_text.includes('switch')){
		let importLib = "ppy";
		let importType = "Switch";
		let initBit = "userSwitch = Switch()"; 
		let strucProp = 
		{
			importLib:importLib,
			importType:importType,
			initBit:initBit
		};	
		checkForImport(strucProp);
	}
	if(xml_text.includes('milli')){
		let importLib = "ppy";
		let importType = "millis";
		let initBit = ""; 
		let strucProp = 
		{
			importLib:importLib,
			importType:importType,
			initBit:initBit
		};	
		checkForImport(strucProp);		
	}
}


function checkForImport(struct){
	
	let found = false;
	
	if (ppyBlocksSpe.length){
		ppyBlocksSpe.forEach(
			function(dico){
				if( dico.importType == struct.importType ){
					found = true;
				}
			}
				
		);
		if (!found){
			ppyBlocksSpe.push(struct);
		}
	}else{
		ppyBlocksSpe.push(struct);
	}
	
}
var startTimer;
var stopRequested = false; // Variable pour marquer si un arrêt est demandé

function launchCode() {
    // Vérifie si un arrêt a été demandé, et si c'est le cas, affiche la boîte de dialogue
    if (stopRequested) {
        // Affichage de la boîte de dialogue
        document.getElementById('SLocalMenu').style.display = 'block';
        return; // Arrête l'exécution du reste de la fonction
    }

    // Le reste de votre logique actuelle pour lancer le code après la vérification d'arrêt
    if (ppy.isInRAWReplMode()) {
        ppy.exitRawRepl(function () {
            ppy.sendCtrlKey(0x03);
        });
    } else {
        ppy.sendCtrlKey(0x03);
    }
    
    setTimeout(() => {
        if (stateconnected == true) {
            if (!userREPLInstalled) {
                ppy.enterRawRepl().then(function () {
                    userREPLInstalled = false;

                    ppy.exec(editor.getValue(), false, true).then(function () {
                        startTimer = Date.now();
                    });
                });
            }
        } else {
            // displayConnectionPanel();
            connectionPPY();
        }
    }, 1000);
}

// Fonction pour réinitialiser le graphique lors de l'appel de "Relancer"
function relancer() {
    resetGraph();
    reInitChart();
    InitGrosChiffre();
    ReinitTableur();
	stopRequested = false;
	FermerSLocal();
}

function resetGraph() {
    // Ajout des étapes pour réinitialiser le graphique
    graphConfig = initChartConf(
        title = formatTitle(null, null),
        serieColor = [['rgb(255,0,0)', strYAxisLeft], ['rgb(0,255,0)', strYAxisRight]],
        xAxisCaption = formatTimeAxisStr(samplingRate),
        gridLinesColor = "#dee6ef",
        leftYaxisCaption = strYAxisLeft,
        rightYaxisCaption = strYAxisRight,
        prevChartConf = null
    );
    // Autres opérations de réinitialisation si nécessaires dans les prochaines versions
}
function enregistrer() {
	FermerSLocal();
    exportcsv(); // Appel de la fonction exportcsv() pour enregistrer les données
	stopRequested = false;
}


function StopProgram() {
    stopRequested = true; // Marque qu'un arrêt est demandé

    // logique pour arrêter le programme, sans effacer le code
    if (stateconnected == true) {
        if (ppy.isInRAWReplMode()) {
            ppy.exitRawRepl(function () {
                // Arrêter les composants sans effacer leur contenu
                ReinitTableur();
                ppy.sendCtrlKey(0x03);
            });
        } else {
            // Arrêter les composants sans effacer leur contenu
            ReinitTableur();
            ppy.sendCtrlKey(0x03);
        }
    } else {
        // displayConnectionPanel();
        connectionPPY();
    }
}


var readingState = 0;
var sharedGrosChiffreDataReq = ""
this.sharedDataReqSize = 4;


function tryParseFsAnswer(inStr,outCB){
	try{
		outCB(JSON.parse(inStr));
		
	}catch(err){
		console.warn("Unable to parse FS. answer ("+err+')');
	}
}
function strShift(shiftCount){
	res = sharedGrosChiffreDataReq.slice(0,shiftCount);
	sharedGrosChiffreDataReq = sharedGrosChiffreDataReq.slice(shiftCount,sharedGrosChiffreDataReq.length);
	return res;
}

function GrosChiffrePushData(data){
	handleReplMsg(data);
	sharedGrosChiffreDataReq += data;		
			while(sharedGrosChiffreDataReq.length){
				this.sharedDataReqSize = parseInt(strShift(2));
				if ( !isNaN(this.sharedDataReqSize) ){					
					if ( sharedGrosChiffreDataReq.length == this.sharedDataReqSize ){			
						partseData(sharedGrosChiffreDataReq);
						sharedGrosChiffreDataReq = "";						
					}else
						if ( sharedGrosChiffreDataReq.length < this.sharedDataReqSize )													
							readingState = 1;							
						else
							sharedGrosChiffreDataReq = "";											
					break;					
				}				
			}			
}

var counterLeg = 0;
var Unit = "";
var Valeur = "";
function InitGrosChiffre(){
	grosChiffrevue = document.getElementById('GrosChiffreView');
	// unitForGroschiffre = document.getElementById('unitGrosChiffre');
	// grosChiffrevue.style.fontFamily = "clock"
	grosChiffrevue.style.fontSize = '7em';
	grosChiffrevue.style.textAlign = 'center';
	grosChiffrevue.style.opacity = "0.3"
	grosChiffrevue.innerHTML = 8888.8;
	// unitForGroschiffre.style.textAlign = "center";
	// unitForGroschiffre.style.fontSize = "6.7em";
	// unitForGroschiffre.style.opacity = "0.3";
	// unitForGroschiffre.innerHTML = "...";
}

    
   


function GrosChiffreFeedData(unite, value){
	grosChiffrevue = document.getElementById('GrosChiffreView');
	str = value + " " + unite;
	grosChiffrevue.style.fontSize = '7em';
	grosChiffrevue.style.textAlign = 'center';
	grosChiffrevue.style.opacity = "1"
	grosChiffrevue.innerHTML = str;
	// unitForGroschiffre.style.textAlign = "center";
	// unitForGroschiffre.style.fontSize = "6.7em";
	// unitForGroschiffre.style.opacity = "1";
	// unitForGroschiffre.innerHTML = unite;
	
}
var msfromgraph = 0;
function partseData(data){
	try{
		res = tryGrosChiffreParseJson(JSON.parse(data))
		id = res[0];
		Unit = res[2];
		Valeur = res[1];

		InputUnit = res[4];
		InputValue = res[3];
		if(id == "8"){
			GrosChiffreFeedData(InputUnit, InputValue);
		}else{
			GrosChiffreFeedData(Unit, Valeur);
		}
		

			feedGraphDataSets(Valeur, InputValue);
			if(InputValue == "None"){
				FeedTableur(null, Valeur);
			}else{
				FeedTableur(InputValue, Valeur);
			}
		
		
	}catch(err){
		// console.warn("Erreur pars data  err : ",err);
	}
}

function setmsFromGraph(ms){
	msfromgraph += ms;	
}


/////////////////////////////////////// CHART CONF ///////////////////////////////////////////
const strBaseTitle = "";
const strBaseXAxisName = "";
let strYAxisLeft = "";
let strYAxisRight = "";
var samplingRate = 25;
var firsttimepass = 0;

function initgraphString(strTitle, strBasX, strYaxisLeft, strYaxisRight) {
    strBaseTitle = strTitle;
    strBaseXAxisName = strBasX;
    strYAxisLeft = strYaxisLeft;
    strYAxisRight = strYaxisRight;
    reInitChart();
}

function feedGraphDataSets(val, inputvalue) {
    graphConfig.options.scales.xAxes[0].ticks.beginAtZero = false;
    let dataSetCounter = 0;
    if (inputvalue != "None") {
        graphConfig.options.scales.yAxes[0].ticks.beginAtZero = false;
        graphConfig.data.datasets[dataSetCounter].data.push({
            x: inputvalue,
            y: val
        });
    } else {
        if (firsttimepass == 0) {
            firsttimepass = 1;
            graphConfig.data.datasets[0].data.push({
                x: 0,
                y: 0,
            });
        }
        graphConfig.data.datasets[dataSetCounter].data.push({
            x: (Date.now() - startTimer) / 1000,
            y: val,
        });
        setmsFromGraph(graphConfig.data.datasets[dataSetCounter].data[graphConfig.data.datasets[dataSetCounter].data.length - 1].x + 1);
    }
    dataSetCounter += 1;
    myLine.update();
}

var testt = 0;

function initChartConf(titleStr = null, serieData = null, xAxisCaption = null, gridLinesColor = "#dee6ef", leftYaxisCaption = null, rightYaxisCaption = null, prevChartConf = null) {
    var color = Chart.helpers.color;
    var chartConf = prevChartConf;
    if (prevChartConf == null) {
        chartConf = {
            type: 'line',
            data: {
                datasets: []
            },
            options: {
                showLines: false,
                responsive: true,
                maintainAspectRatio: false,
                title: {
                    display: false,
                    text: titleStr,
                    fontColor: "#dee6ef",
                },
                elements: {
                    point: {
                        pointStyle: "cross",
                        borderWidth: 2,
                        radius: 5,
                        backgroundColor: "#ff0000",
                    },
                    line: {
                        tension: "0",
                    },
                },
                scales: {
                    xAxes: [{
                        gridLines: {
                            color: gridLinesColor
                        },
                        type: 'linear',
                        display: true,
                        scaleLabel: {
                            display: true,
                            labelString: xAxisCaption,
                            fontColor: "#dee6ef"
                        },
                        ticks: {
                            stepSize: 1,
                            beginAtZero: false,
                            fontColor: "#dee6ef"
                        }
                    }],
                    yAxes: []
                },
                legend: {
                    display: false
                },
                animation: {
                    duration: 0
                },
                hover: {
                    animationDuration: 0
                },
                responsiveAnimationDuration: 0
            }
        };
    }
    if (titleStr != null)
        chartConf.options.title.display = true;

    if (leftYaxisCaption != null)
        chartConf.options.scales.yAxes.push({
            gridLines: {
                color: gridLinesColor
            },
            display: true,
            position: 'left',
            id: '0',
            scaleLabel: {
                display: true,
                labelString: leftYaxisCaption,
                fontColor: "#dee6ef",
            },
            ticks: {
                fontColor: "#dee6ef",
                suggestedMax: 1,
                suggestedMin: 0,
                beginAtZero: true
            }
        });


    if (rightYaxisCaption != null)
        chartConf.options.scales.yAxes.push({
            gridLines: {
                color: gridLinesColor
            },
            display: false,
            position: 'right',
            id: '1',
            scaleLabel: {
                display: false,
                labelString: rightYaxisCaption,
                fontColor: "#dee6ef",
            },
            ticks: {
                fontColor: "#dee6ef",
                suggestedMax: 1,
                suggestedMin: 0,
                beginAtZero: true
            }
        });

    if (serieData != null) {
        let labelAxisCounter = 0;
        serieData.forEach(function(data) {
            chartConf.data.datasets.push({
                hidden: false,
                label: data[1],
                yAxisID: String(labelAxisCounter),
                backgroundColor: color(data[0]).alpha(0.125 / 2).rgbString(),
                borderColor: data[0],
                fill: true,
            });
            labelAxisCounter++;
        });
    }


    return chartConf;
}

	// graphConfig.options.elements.line.tension = 0;
	
	function round(num, decimalPlaces = 0) {
		num = Math.round(Math.abs(num) + "e" + decimalPlaces) * Math.sign(num);
		return Number(num + "e" + -decimalPlaces);
	}
	
	var graphConfig = initChartConf(
		title = formatTitle(null,null),		
		serieColor = [['rgb(255,0,0)',strYAxisLeft],['rgb(0,255,0)',strYAxisRight]],
		xAxisCaption = formatTimeAxisStr(samplingRate),
		gridLinesColor = "#dee6ef",
		leftYaxisCaption = strYAxisLeft,
		rightYaxisCaption = strYAxisRight,
		prevChartConf = null
	);
	
	function formatTimeAxisStr(sampleRateValue){
		let ms = round(1/sampleRateValue,3);
		return "Temps (en s) ";
		// return strBaseXAxisName+" (n*"+String(ms)+" ms)";
	}

	
	function graphUpdateTimeLegeng(sampleRateValue){
		if(sampleRateValue != ""){
			graphConfig.options.scales.xAxes[0].scaleLabel.labelString = sampleRateValue;
		}else{
			graphConfig.options.scales.xAxes[0].scaleLabel.labelString = formatTimeAxisStr(sampleRateValue);
		}		
	}
	function graphUpdateYaxesLeftTitle(sampleRateValue){
		graphConfig.options.scales.yAxes[0].scaleLabel.labelString = sampleRateValue;
	}
	
	function formatTitle(speed,distance){
		let out = strBaseTitle;		
		if (speed!=null && distance!= null){
			speed=round(speed,3);
			distance=round(distance,3);
			out += " (V="+String(speed.toFixed(3))+" m/s D="+String(distance.toFixed(3))+" m)";
		}
		return out;
	}
	
	function graphUpdateGraphTitle(titleName){
		graphConfig.options.title.text = titleName;
	}
	
	function channelsEnabler(ch1,ch2){
	
		graphConfig.options.scales.yAxes[0].display = true;
		graphConfig.data.datasets[0].hidden = false;
		
		graphConfig.options.scales.yAxes[1].display = true;
		graphConfig.data.datasets[1].hidden = false;
		
		if(!ch1){
			graphConfig.options.scales.yAxes[0].display = false;
			graphConfig.data.datasets[0].hidden = true;
		}
		
		if(!ch2){
			graphConfig.options.scales.yAxes[1].display = false;
			graphConfig.data.datasets[1].hidden = true;
		}
		myLine.update();
	
	}
	
	Chart.defaults.global.defaultFontSize = 16;
	myLine = new Chart(document.getElementById('graph').getContext('2d'), graphConfig);
	
	
	function reInitChart(){
		firsttimepass = 0;
		setTimeout(function(){
			myLine.destroy();
			myLine = new Chart(document.getElementById('graph').getContext('2d'), graphConfig);
			setTimeout(function(){
				myLine.destroy();
				myLine = new Chart(document.getElementById('graph').getContext('2d'), graphConfig);
			},250);
		},250);
		
	}

	function clearDataset(){
		for( i = 0 ; i < graphConfig.data.datasets.length ; i++ ){
			graphConfig.data.datasets.shift();
		}
		graphConfig.dataSetCounter = 0;
		myLine.update();
	}

	function setGraphLine(){
		if(graphConfig.options.showLines == false){
			graphConfig.options.showLines = true;
			document.getElementById('setLine').childNodes[0].src = "ressource/svg/006-graphique-de-ligne-de-courbe-de-statistiques-commerciales.svg"
		}else if(graphConfig.options.showLines == true){
			graphConfig.options.showLines = false;
			document.getElementById('setLine').childNodes[0].src = "ressource/svg/007-graphique-a-nuage-de-points.svg";
		}
		myLine.update();
	}


ContentForTableur = document.getElementById("tableurContent");

var NewTable;
var DataFeedTab;
var oldTitleX;
var oldTitleY;
function InitTableur(TitleY, TitleX){
	DataFeedTab = 1;
	NewColTable = document.createElement("tr");
	var NewTitleY = document.createElement("td");
	var NewTitleX = document.createElement("td");
	NewTable = document.createElement('table');
	NewTable.id = "table"
	NewTitleX.innerHTML = TitleX;
	NewTitleY.innerHTML = TitleY;
	oldTitleX = TitleX;
	oldTitleY = TitleY;
	ContentForTableur.className = "tabcontent";
	NewTable.className = "tab";
	NewColTable.appendChild(NewTitleX);
	NewColTable.appendChild(NewTitleY);
	NewTable.appendChild(NewColTable);

	
	NewTable.appendChild(NewColTable);
	ContentForTableur.appendChild(NewTable);
	
}
function ReinitTableur(all){
	ContentForTableur.childNodes.forEach(element => {
		ContentForTableur.removeChild(element)
	});
	if(all == null){
		InitTableur(oldTitleY, oldTitleX);
	}else{
		all = null;
	}
}
var FirstPass = true;
function FeedTableur(dataX, dataY){
	
	let NewFeed = document.createElement("tr");
	let FeedX = document.createElement("td");
	let FeedY = document.createElement("td");

	FeedX.id = "dataX" + DataFeedTab;
	FeedY.id = "dataY" + DataFeedTab;

	if(dataX != null){
		FeedX.innerHTML = dataX;
	}else{
		FeedX.innerHTML = (Date.now() - startTimer) /1000;
	}
	FeedY.innerHTML = dataY;

	NewFeed.appendChild(FeedX);
	NewFeed.appendChild(FeedY);

	document.getElementById("table").appendChild(NewFeed);
	DataFeedTab++;
}

function exportcsv(){
	if(document.getElementById("formNewCSV").style.display != "block"){
		document.getElementById("BS_Background").style.display = "block";
		document.getElementById("formNewCSV").style.display = "block";
	}else{
		document.getElementById("BS_Background").style.display = "none";
		document.getElementById("formNewCSV").style.display = "none";
	}


}

function submitFormCSV(){

	if(document.getElementById('NameCSV').value != ""){
		CSVname = document.getElementById('NameCSV').value;
		document.getElementById('formNewCSV').style.display = "none";
		document.getElementById("BS_Background").style.display = "none";

		let compteur = 0;
		let elementtab = []
		var str = "";
			document.getElementById("table").childNodes.forEach(element => {
				element.childNodes.forEach(element2 => {
					str = str.replace(".", ",");
					if(compteur == 2){
						str += "\n";	
						compteur = 0;
					}
					str += element2.textContent;
					
					if(compteur == 1){
					}else{
						
						str += ";";
					}
					compteur++;			
				});
				// str = str.replace(".", ",");	
			});
			str = str.replace(".", ",");
			console.log(str)
			var hiddenElement = document.createElement('a');
			hiddenElement.href = 'data:text/csv;charset=utf-8,' + encodeURI(str);
			hiddenElement.target = '_blank';
			hiddenElement.download = CSVname;
			hiddenElement.click();

	}else {
		window.alert("Veuillez remplir le champ vide !")
	}

}
const deleteButtons = document.querySelectorAll('.ResizeBtn');
const deletedPoints = []; 

deleteButtons.forEach(button => {
    button.addEventListener('click', function() {
        const pointIndex = parseInt(document.getElementById('pointToDelete').value, 10);
        deleteGraphPoint(pointIndex - 1); 
        document.getElementById('pointToDelete').value = ''; 
    });
});

function deleteGraphPoint(pointIndex) {
    const dataset = graphConfig.data.datasets[0]; 
    if (dataset.data.length >= pointIndex && pointIndex >= 0) {
        const deletedPoint = dataset.data.splice(pointIndex, 1)[0];
        deletedPoints.push(deletedPoint);
        myLine.update(); 
    }
}


const restoreButton = document.querySelector('.restoreButton');
restoreButton.addEventListener('click', function() {
    restoreDeletedPoint(); 
});


function restoreDeletedPoint() {
    if (deletedPoints.length > 0) {
        const dataset = graphConfig.data.datasets[0]; 
        const lastDeletedPoint = deletedPoints.pop(); 
        dataset.data.push(lastDeletedPoint); 
        myLine.update();
    }
}
const canvas = document.getElementById('graph');
let currentPopup = null;

canvas.addEventListener('mousemove', function (event) {
    const activePoints = myLine.getElementsAtEventForMode(event, 'nearest', { intersect: true }, false);

    if (activePoints.length > 0) {
        const idx = activePoints[0]._index + 1; 

        
        const mouseX = event.clientX;
        const mouseY = event.clientY;

       
            
		currentPopup.textContent = `Point: ${idx}`;
		currentPopup.style.top = `${mouseY + 20}px`;
		currentPopup.style.left = `${mouseX + 20}px`;
        
    } else if (currentPopup) {
       
        currentPopup.remove();
        currentPopup = null;
    }
});
  function enregistrerFichiers() {
          
            console.log("Enregistrement des fichiers .blk et .py");
        }

        // Attacher l'événement beforeunload à la fenêtre
        window.addEventListener('beforeunload', function (event) {
           
            enregistrerFichiers();
            
            
            var message = "Des modifications non enregistrées peuvent être perdues. Êtes-vous sûr de vouloir quitter?";
            event.returnValue = message; // Standard
            return message; // Pour certains navigateurs anciens
        });
		
function enregistrerFichiersAvantFermeture() {
    if (stateconnected === true) {
        let strFilePartPy = btoa(editor.getValue());

        var xml = Blockly.Xml.workspaceToDom(workspace);
        var xml_text = Blockly.Xml.domToText(xml);

        
        if (!xml_text.trim()) {
            xml_text = '';
        }

        let strFilePartBlk = btoa(xml_text);

        // Utiliser le chemin actuel pour les noms de fichier
        var nomFichierSansExtension = currenFilePath.substr(1) + currenFilePath.substr(currenFilePath.lastIndexOf("/"));
        
        // Créer les commandes pour enregistrer les fichiers
        var cmd = "";
        cmd += "file = open(\"" + nomFichierSansExtension + ".py\",'w')" + "\r\n";
        cmd += "file.write('" + strFilePartPy + "')" + "\r\n";
        cmd += "file.close()" + "\r\n";
        cmd += "file = open(\"" + nomFichierSansExtension + ".blk\",'w')" + "\r\n";
        cmd += "file.write(\"" + strFilePartBlk + "\")" + "\r\n";
        cmd += "file.close()" + "\r\n";

        // Exécuter les commandes dans le contexte MicroPython
        if (!ppy.isInRAWReplMode()) {
            ppy.enterRawRepl().then(function (res) {
                ppy.exec(cmd).then(function (res) {
                    
                });
            });
        } else {
            ppy.exec(cmd).then(function (res) {
                
            });
        }
    } else {
        connectionPPY();
    }
}
window.addEventListener('beforeunload', function (event) {
    enregistrerFichiersAvantFermeture();
    
    var message = "Des modifications non enregistrées peuvent être perdues. Êtes-vous sûr de vouloir quitter?";
    
    // Utilisez la propriété `returnValue` de l'événement
    event.returnValue = message;

    // Pour une compatibilité avec les navigateurs anciens
    return message;
});

var autoriserEdition = true;

// Fonction pour bloquer la saisie dans l'éditeur
function bloquerSaisie(event) {
    // Annuler l'événement d'entrée (saisie de texte)
    event.preventDefault();
}

// Fonction pour afficher une popup d'avertissement lors du clic sur l'espace de l'éditeur
function afficherPopupAvertissement(event) {
    console.log("Clic détecté sur l'éditeur");

    if (autoriserEdition) {
        var confirmer = window.confirm("Attention : Veuillez tirer le bloc <Code> présent dans l'éditeur.");

        if (!confirmer) {
            // Désactiver l'édition après confirmation
            console.log("Édition désactivée après confirmation");
            autoriserEdition = false;
            editorElement.removeAttribute('contenteditable');
            editorElement.removeEventListener('input', bloquerSaisie);
        } else {
            // Annuler l'événement de clic si l'utilisateur a cliqué sur "Annuler" dans la popup
            console.log("Événement de clic annulé après annulation de la confirmation");
            event.preventDefault();
        }
    }
}

var editorElement = document.getElementById('editor');

if (editorElement) {
    editorElement.addEventListener('click', afficherPopupAvertissement);
    editorElement.addEventListener('input', bloquerSaisie);
}
